/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Timer3: ImageVector
    get() {
        if (_timer3 != null) {
            return _timer3!!
        }
        _timer3 = materialIcon(name = "Sharp.Timer3") {
            materialPath {
                moveTo(11.61f, 12.97f)
                curveToRelative(-0.16f, -0.24f, -0.36f, -0.46f, -0.62f, -0.65f)
                curveToRelative(-0.25f, -0.19f, -0.56f, -0.35f, -0.93f, -0.48f)
                curveToRelative(0.3f, -0.14f, 0.57f, -0.3f, 0.8f, -0.5f)
                curveToRelative(0.23f, -0.2f, 0.42f, -0.41f, 0.57f, -0.64f)
                curveToRelative(0.15f, -0.23f, 0.27f, -0.46f, 0.34f, -0.71f)
                curveToRelative(0.08f, -0.24f, 0.11f, -0.49f, 0.11f, -0.73f)
                curveToRelative(0.0f, -0.55f, -0.09f, -1.04f, -0.28f, -1.46f)
                curveToRelative(-0.18f, -0.42f, -0.44f, -0.77f, -0.78f, -1.06f)
                curveToRelative(-0.33f, -0.28f, -0.73f, -0.5f, -1.2f, -0.64f)
                curveToRelative(-0.45f, -0.13f, -0.97f, -0.2f, -1.53f, -0.2f)
                curveToRelative(-0.55f, 0.0f, -1.06f, 0.08f, -1.52f, 0.24f)
                curveToRelative(-0.47f, 0.17f, -0.87f, 0.4f, -1.2f, 0.69f)
                curveToRelative(-0.33f, 0.29f, -0.6f, 0.63f, -0.78f, 1.03f)
                curveToRelative(-0.2f, 0.39f, -0.29f, 0.83f, -0.29f, 1.29f)
                horizontalLineToRelative(1.98f)
                curveToRelative(0.0f, -0.26f, 0.05f, -0.49f, 0.14f, -0.69f)
                curveToRelative(0.09f, -0.2f, 0.22f, -0.38f, 0.38f, -0.52f)
                curveToRelative(0.17f, -0.14f, 0.36f, -0.25f, 0.58f, -0.33f)
                reflectiveCurveToRelative(0.46f, -0.12f, 0.73f, -0.12f)
                curveToRelative(0.61f, 0.0f, 1.06f, 0.16f, 1.36f, 0.47f)
                curveToRelative(0.3f, 0.31f, 0.44f, 0.75f, 0.44f, 1.32f)
                curveToRelative(0.0f, 0.27f, -0.04f, 0.52f, -0.12f, 0.74f)
                curveToRelative(-0.08f, 0.22f, -0.21f, 0.41f, -0.38f, 0.57f)
                reflectiveCurveToRelative(-0.38f, 0.28f, -0.63f, 0.37f)
                reflectiveCurveToRelative(-0.55f, 0.13f, -0.89f, 0.13f)
                lineTo(6.72f, 11.09f)
                verticalLineToRelative(1.57f)
                lineTo(7.9f, 12.66f)
                curveToRelative(0.34f, 0.0f, 0.64f, 0.04f, 0.91f, 0.11f)
                curveToRelative(0.27f, 0.08f, 0.5f, 0.19f, 0.69f, 0.35f)
                curveToRelative(0.19f, 0.16f, 0.34f, 0.36f, 0.44f, 0.61f)
                curveToRelative(0.1f, 0.24f, 0.16f, 0.54f, 0.16f, 0.87f)
                curveToRelative(0.0f, 0.62f, -0.18f, 1.09f, -0.53f, 1.42f)
                curveToRelative(-0.35f, 0.33f, -0.84f, 0.49f, -1.45f, 0.49f)
                curveToRelative(-0.29f, 0.0f, -0.56f, -0.04f, -0.8f, -0.13f)
                curveToRelative(-0.24f, -0.08f, -0.44f, -0.2f, -0.61f, -0.36f)
                reflectiveCurveToRelative(-0.3f, -0.34f, -0.39f, -0.56f)
                curveToRelative(-0.09f, -0.22f, -0.14f, -0.46f, -0.14f, -0.72f)
                lineTo(4.19f, 14.74f)
                curveToRelative(0.0f, 0.55f, 0.11f, 1.03f, 0.32f, 1.45f)
                curveToRelative(0.21f, 0.42f, 0.5f, 0.77f, 0.86f, 1.05f)
                reflectiveCurveToRelative(0.77f, 0.49f, 1.24f, 0.63f)
                reflectiveCurveToRelative(0.96f, 0.21f, 1.48f, 0.21f)
                curveToRelative(0.57f, 0.0f, 1.09f, -0.08f, 1.58f, -0.23f)
                reflectiveCurveToRelative(0.91f, -0.38f, 1.26f, -0.68f)
                curveToRelative(0.36f, -0.3f, 0.64f, -0.66f, 0.84f, -1.1f)
                curveToRelative(0.2f, -0.43f, 0.3f, -0.93f, 0.3f, -1.48f)
                curveToRelative(0.0f, -0.29f, -0.04f, -0.58f, -0.11f, -0.86f)
                curveToRelative(-0.08f, -0.25f, -0.19f, -0.51f, -0.35f, -0.76f)
                close()
                moveTo(20.87f, 14.37f)
                curveToRelative(-0.14f, -0.28f, -0.35f, -0.53f, -0.63f, -0.74f)
                curveToRelative(-0.28f, -0.21f, -0.61f, -0.39f, -1.01f, -0.53f)
                reflectiveCurveToRelative(-0.85f, -0.27f, -1.35f, -0.38f)
                curveToRelative(-0.35f, -0.07f, -0.64f, -0.15f, -0.87f, -0.23f)
                curveToRelative(-0.23f, -0.08f, -0.41f, -0.16f, -0.55f, -0.25f)
                reflectiveCurveToRelative(-0.23f, -0.19f, -0.28f, -0.3f)
                curveToRelative(-0.05f, -0.11f, -0.08f, -0.24f, -0.08f, -0.39f)
                reflectiveCurveToRelative(0.03f, -0.28f, 0.09f, -0.41f)
                reflectiveCurveToRelative(0.15f, -0.25f, 0.27f, -0.34f)
                curveToRelative(0.12f, -0.1f, 0.27f, -0.18f, 0.45f, -0.24f)
                reflectiveCurveToRelative(0.4f, -0.09f, 0.64f, -0.09f)
                curveToRelative(0.25f, 0.0f, 0.47f, 0.04f, 0.66f, 0.11f)
                reflectiveCurveToRelative(0.35f, 0.17f, 0.48f, 0.29f)
                reflectiveCurveToRelative(0.22f, 0.26f, 0.29f, 0.42f)
                curveToRelative(0.06f, 0.16f, 0.1f, 0.32f, 0.1f, 0.49f)
                horizontalLineToRelative(1.95f)
                curveToRelative(0.0f, -0.39f, -0.08f, -0.75f, -0.24f, -1.09f)
                reflectiveCurveToRelative(-0.39f, -0.63f, -0.69f, -0.88f)
                curveToRelative(-0.3f, -0.25f, -0.66f, -0.44f, -1.09f, -0.59f)
                curveToRelative(-0.43f, -0.15f, -0.92f, -0.22f, -1.46f, -0.22f)
                curveToRelative(-0.51f, 0.0f, -0.98f, 0.07f, -1.39f, 0.21f)
                reflectiveCurveToRelative(-0.77f, 0.33f, -1.06f, 0.57f)
                curveToRelative(-0.29f, 0.24f, -0.51f, 0.52f, -0.67f, 0.84f)
                reflectiveCurveToRelative(-0.23f, 0.65f, -0.23f, 1.01f)
                reflectiveCurveToRelative(0.08f, 0.68f, 0.23f, 0.96f)
                reflectiveCurveToRelative(0.37f, 0.52f, 0.64f, 0.73f)
                curveToRelative(0.27f, 0.21f, 0.6f, 0.38f, 0.98f, 0.53f)
                curveToRelative(0.38f, 0.14f, 0.81f, 0.26f, 1.27f, 0.36f)
                curveToRelative(0.39f, 0.08f, 0.71f, 0.17f, 0.95f, 0.26f)
                reflectiveCurveToRelative(0.43f, 0.19f, 0.57f, 0.29f)
                curveToRelative(0.13f, 0.1f, 0.22f, 0.22f, 0.27f, 0.34f)
                curveToRelative(0.05f, 0.12f, 0.07f, 0.25f, 0.07f, 0.39f)
                curveToRelative(0.0f, 0.32f, -0.13f, 0.57f, -0.4f, 0.77f)
                reflectiveCurveToRelative(-0.66f, 0.29f, -1.17f, 0.29f)
                curveToRelative(-0.22f, 0.0f, -0.43f, -0.02f, -0.64f, -0.08f)
                curveToRelative(-0.21f, -0.05f, -0.4f, -0.13f, -0.56f, -0.24f)
                curveToRelative(-0.17f, -0.11f, -0.3f, -0.26f, -0.41f, -0.44f)
                curveToRelative(-0.11f, -0.18f, -0.17f, -0.41f, -0.18f, -0.67f)
                horizontalLineToRelative(-1.89f)
                curveToRelative(0.0f, 0.36f, 0.08f, 0.71f, 0.24f, 1.05f)
                reflectiveCurveToRelative(0.39f, 0.65f, 0.7f, 0.93f)
                curveToRelative(0.31f, 0.27f, 0.69f, 0.49f, 1.15f, 0.66f)
                curveToRelative(0.46f, 0.17f, 0.98f, 0.25f, 1.58f, 0.25f)
                curveToRelative(0.53f, 0.0f, 1.01f, -0.06f, 1.44f, -0.19f)
                curveToRelative(0.43f, -0.13f, 0.8f, -0.31f, 1.11f, -0.54f)
                curveToRelative(0.31f, -0.23f, 0.54f, -0.51f, 0.71f, -0.83f)
                curveToRelative(0.17f, -0.32f, 0.25f, -0.67f, 0.25f, -1.06f)
                curveToRelative(-0.02f, -0.4f, -0.09f, -0.74f, -0.24f, -1.02f)
                close()
            }
        }
        return _timer3!!
    }

private var _timer3: ImageVector? = null
