/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TextRotateUp: ImageVector
    get() {
        if (_textRotateUp != null) {
            return _textRotateUp!!
        }
        _textRotateUp = materialIcon(name = "Rounded.TextRotateUp") {
            materialPath {
                moveTo(18.35f, 4.35f)
                curveToRelative(-0.2f, -0.2f, -0.51f, -0.2f, -0.71f, 0.0f)
                lineToRelative(-1.79f, 1.79f)
                curveToRelative(-0.31f, 0.32f, -0.09f, 0.86f, 0.36f, 0.86f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(0.79f)
                curveToRelative(0.45f, 0.0f, 0.67f, -0.54f, 0.35f, -0.85f)
                lineToRelative(-1.79f, -1.8f)
                close()
                moveTo(11.8f, 15.5f)
                verticalLineToRelative(-5.0f)
                lineToRelative(1.6f, -0.66f)
                curveToRelative(0.36f, -0.14f, 0.6f, -0.49f, 0.6f, -0.88f)
                curveToRelative(0.0f, -0.69f, -0.71f, -1.15f, -1.34f, -0.88f)
                lineToRelative(-8.97f, 3.88f)
                curveToRelative(-0.42f, 0.17f, -0.69f, 0.58f, -0.69f, 1.04f)
                curveToRelative(0.0f, 0.46f, 0.27f, 0.87f, 0.69f, 1.05f)
                lineToRelative(8.97f, 3.88f)
                curveToRelative(0.63f, 0.27f, 1.34f, -0.2f, 1.34f, -0.89f)
                curveToRelative(0.0f, -0.39f, -0.24f, -0.74f, -0.6f, -0.89f)
                lineToRelative(-1.6f, -0.65f)
                close()
                moveTo(4.98f, 13.0f)
                lineTo(10.0f, 11.13f)
                verticalLineToRelative(3.74f)
                lineTo(4.98f, 13.0f)
                close()
            }
        }
        return _textRotateUp!!
    }

private var _textRotateUp: ImageVector? = null
