/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SmartDisplay: ImageVector
    get() {
        if (_smartDisplay != null) {
            return _smartDisplay!!
        }
        _smartDisplay = materialIcon(name = "Rounded.SmartDisplay") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.0f, 4.9f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(9.5f, 14.67f)
                verticalLineTo(9.33f)
                curveToRelative(0.0f, -0.79f, 0.88f, -1.27f, 1.54f, -0.84f)
                lineToRelative(4.15f, 2.67f)
                curveToRelative(0.61f, 0.39f, 0.61f, 1.29f, 0.0f, 1.68f)
                lineToRelative(-4.15f, 2.67f)
                curveTo(10.38f, 15.94f, 9.5f, 15.46f, 9.5f, 14.67f)
                close()
            }
        }
        return _smartDisplay!!
    }

private var _smartDisplay: ImageVector? = null
