/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Savings: ImageVector
    get() {
        if (_savings != null) {
            return _savings!!
        }
        _savings = materialIcon(name = "Rounded.Savings") {
            materialPath {
                moveTo(19.83f, 7.5f)
                lineToRelative(-2.27f, -2.27f)
                curveToRelative(0.07f, -0.42f, 0.18f, -0.81f, 0.32f, -1.15f)
                curveToRelative(0.11f, -0.26f, 0.15f, -0.56f, 0.09f, -0.87f)
                curveTo(17.84f, 2.49f, 17.14f, 1.99f, 16.4f, 2.0f)
                curveToRelative(-1.59f, 0.03f, -3.0f, 0.81f, -3.9f, 2.0f)
                lineToRelative(-5.0f, 0.0f)
                curveTo(4.46f, 4.0f, 2.0f, 6.46f, 2.0f, 9.5f)
                curveToRelative(0.0f, 2.25f, 1.37f, 7.48f, 2.08f, 10.04f)
                curveTo(4.32f, 20.4f, 5.11f, 21.0f, 6.01f, 21.0f)
                lineTo(8.0f, 21.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(0.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                lineToRelative(2.01f, 0.0f)
                curveToRelative(0.88f, 0.0f, 1.66f, -0.58f, 1.92f, -1.43f)
                lineToRelative(1.25f, -4.16f)
                lineToRelative(2.14f, -0.72f)
                curveToRelative(0.41f, -0.14f, 0.68f, -0.52f, 0.68f, -0.95f)
                verticalLineTo(8.5f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(19.83f)
                close()
                moveTo(12.0f, 9.0f)
                horizontalLineTo(9.0f)
                curveTo(8.45f, 9.0f, 8.0f, 8.55f, 8.0f, 8.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(13.0f, 8.55f, 12.55f, 9.0f, 12.0f, 9.0f)
                close()
                moveTo(16.0f, 11.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(17.0f, 10.55f, 16.55f, 11.0f, 16.0f, 11.0f)
                close()
            }
        }
        return _savings!!
    }

private var _savings: ImageVector? = null
