/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PlayLesson: ImageVector
    get() {
        if (_playLesson != null) {
            return _playLesson!!
        }
        _playLesson = materialIcon(name = "Rounded.PlayLesson") {
            materialPath {
                moveTo(18.0f, 11.0f)
                curveToRelative(0.34f, 0.0f, 0.67f, 0.03f, 1.0f, 0.08f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 2.0f, 3.0f, 2.9f, 3.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.26f)
                curveTo(11.47f, 20.87f, 11.0f, 19.49f, 11.0f, 18.0f)
                curveTo(11.0f, 14.13f, 14.13f, 11.0f, 18.0f, 11.0f)
                close()
                moveTo(7.76f, 10.55f)
                curveTo(7.42f, 10.75f, 7.0f, 10.51f, 7.0f, 10.12f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(6.12f)
                curveToRelative(0.0f, 0.39f, -0.42f, 0.63f, -0.76f, 0.43f)
                lineTo(9.5f, 9.5f)
                lineTo(7.76f, 10.55f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(16.75f, 19.6f)
                verticalLineToRelative(-3.2f)
                curveToRelative(0.0f, -0.39f, 0.43f, -0.63f, 0.76f, -0.42f)
                lineToRelative(2.56f, 1.6f)
                curveToRelative(0.31f, 0.2f, 0.31f, 0.65f, 0.0f, 0.85f)
                lineToRelative(-2.56f, 1.6f)
                curveTo(17.18f, 20.23f, 16.75f, 19.99f, 16.75f, 19.6f)
                close()
            }
        }
        return _playLesson!!
    }

private var _playLesson: ImageVector? = null
