/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Hardware: ImageVector
    get() {
        if (_hardware != null) {
            return _hardware!!
        }
        _hardware = materialIcon(name = "Rounded.Hardware") {
            materialPath {
                moveTo(17.59f, 3.41f)
                lineTo(15.0f, 6.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(9.0f)
                curveTo(6.24f, 3.0f, 4.0f, 5.24f, 4.0f, 8.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(8.0f)
                lineToRelative(2.59f, 2.59f)
                curveToRelative(0.26f, 0.26f, 0.62f, 0.41f, 1.0f, 0.41f)
                horizontalLineToRelative(0.01f)
                curveTo(19.37f, 11.0f, 20.0f, 10.37f, 20.0f, 9.59f)
                verticalLineTo(4.41f)
                curveTo(20.0f, 3.63f, 19.37f, 3.0f, 18.59f, 3.0f)
                horizontalLineToRelative(-0.01f)
                curveTo(18.21f, 3.0f, 17.85f, 3.15f, 17.59f, 3.41f)
                close()
            }
            materialPath {
                moveTo(9.0f, 13.0f)
                verticalLineToRelative(7.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineTo(9.0f)
                close()
            }
        }
        return _hardware!!
    }

private var _hardware: ImageVector? = null
