/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Yard: ImageVector
    get() {
        if (_yard != null) {
            return _yard!!
        }
        _yard = materialIcon(name = "Outlined.Yard") {
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-3.31f, 0.0f, -6.0f, 2.69f, -6.0f, 6.0f)
                curveTo(15.31f, 19.0f, 18.0f, 16.31f, 18.0f, 13.0f)
                close()
                moveTo(6.0f, 13.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveTo(12.0f, 15.69f, 9.31f, 13.0f, 6.0f, 13.0f)
                close()
                moveTo(8.0f, 11.03f)
                curveToRelative(0.0f, 0.86f, 0.7f, 1.56f, 1.56f, 1.56f)
                curveToRelative(0.33f, 0.0f, 0.63f, -0.1f, 0.89f, -0.28f)
                lineToRelative(-0.01f, 0.12f)
                curveToRelative(0.0f, 0.86f, 0.7f, 1.56f, 1.56f, 1.56f)
                reflectiveCurveToRelative(1.56f, -0.7f, 1.56f, -1.56f)
                lineToRelative(-0.01f, -0.12f)
                curveToRelative(0.25f, 0.17f, 0.56f, 0.28f, 0.89f, 0.28f)
                curveToRelative(0.86f, 0.0f, 1.56f, -0.7f, 1.56f, -1.56f)
                curveToRelative(0.0f, -0.62f, -0.37f, -1.16f, -0.89f, -1.41f)
                curveTo(15.63f, 9.38f, 16.0f, 8.84f, 16.0f, 8.22f)
                curveToRelative(0.0f, -0.86f, -0.7f, -1.56f, -1.56f, -1.56f)
                curveToRelative(-0.33f, 0.0f, -0.63f, 0.1f, -0.89f, 0.28f)
                lineToRelative(0.01f, -0.12f)
                curveToRelative(0.0f, -0.86f, -0.7f, -1.56f, -1.56f, -1.56f)
                reflectiveCurveToRelative(-1.56f, 0.7f, -1.56f, 1.56f)
                lineToRelative(0.01f, 0.12f)
                curveTo(10.2f, 6.76f, 9.89f, 6.66f, 9.56f, 6.66f)
                curveTo(8.7f, 6.66f, 8.0f, 7.36f, 8.0f, 8.22f)
                curveToRelative(0.0f, 0.62f, 0.37f, 1.16f, 0.89f, 1.41f)
                curveTo(8.37f, 9.87f, 8.0f, 10.41f, 8.0f, 11.03f)
                close()
                moveTo(12.0f, 8.06f)
                curveToRelative(0.86f, 0.0f, 1.56f, 0.7f, 1.56f, 1.56f)
                reflectiveCurveToRelative(-0.7f, 1.56f, -1.56f, 1.56f)
                reflectiveCurveToRelative(-1.56f, -0.7f, -1.56f, -1.56f)
                reflectiveCurveTo(11.14f, 8.06f, 12.0f, 8.06f)
                close()
                moveTo(20.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(20.0f)
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
            }
        }
        return _yard!!
    }

private var _yard: ImageVector? = null
