/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ScreenSearchDesktop: ImageVector
    get() {
        if (_screenSearchDesktop != null) {
            return _screenSearchDesktop!!
        }
        _screenSearchDesktop = materialIcon(name = "Outlined.ScreenSearchDesktop") {
            materialPath {
                moveTo(4.0f, 18.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.9f, 1.99f, -2.0f)
                lineTo(22.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 3.0f, 2.0f, 3.9f, 2.0f, 5.0f)
                verticalLineToRelative(11.0f)
                curveTo(2.0f, 17.1f, 2.9f, 18.0f, 4.0f, 18.0f)
                close()
                moveTo(4.0f, 5.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(11.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(1.0f, 19.0f)
                horizontalLineToRelative(22.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-22.0f)
                close()
            }
            materialPath {
                moveTo(13.97f, 7.53f)
                curveToRelative(-1.37f, -1.37f, -3.58f, -1.37f, -4.95f, 0.0f)
                reflectiveCurveToRelative(-1.37f, 3.58f, 0.0f, 4.95f)
                curveToRelative(1.18f, 1.18f, 3.0f, 1.34f, 4.36f, 0.47f)
                lineToRelative(2.09f, 2.09f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(-2.09f, -2.09f)
                curveTo(15.31f, 10.53f, 15.16f, 8.71f, 13.97f, 7.53f)
                close()
                moveTo(12.91f, 11.41f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, 0.0f)
                curveToRelative(-0.78f, -0.78f, -0.78f, -2.05f, 0.0f, -2.83f)
                reflectiveCurveToRelative(2.05f, -0.78f, 2.83f, 0.0f)
                curveTo(13.69f, 9.37f, 13.69f, 10.63f, 12.91f, 11.41f)
                close()
            }
        }
        return _screenSearchDesktop!!
    }

private var _screenSearchDesktop: ImageVector? = null
