/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FrontHand: ImageVector
    get() {
        if (_frontHand != null) {
            return _frontHand!!
        }
        _frontHand = materialIcon(name = "Outlined.FrontHand") {
            materialPath {
                moveTo(18.5f, 8.0f)
                curveToRelative(-0.17f, 0.0f, -0.34f, 0.02f, -0.5f, 0.05f)
                verticalLineTo(4.5f)
                curveTo(18.0f, 3.12f, 16.88f, 2.0f, 15.5f, 2.0f)
                curveToRelative(-0.19f, 0.0f, -0.37f, 0.02f, -0.54f, 0.06f)
                curveTo(14.75f, 0.89f, 13.73f, 0.0f, 12.5f, 0.0f)
                curveToRelative(-1.06f, 0.0f, -1.96f, 0.66f, -2.33f, 1.59f)
                curveTo(9.96f, 1.53f, 9.73f, 1.5f, 9.5f, 1.5f)
                curveTo(8.12f, 1.5f, 7.0f, 2.62f, 7.0f, 4.0f)
                verticalLineToRelative(0.55f)
                curveTo(6.84f, 4.52f, 6.67f, 4.5f, 6.5f, 4.5f)
                curveTo(5.12f, 4.5f, 4.0f, 5.62f, 4.0f, 7.0f)
                verticalLineToRelative(8.5f)
                curveToRelative(0.0f, 4.69f, 3.81f, 8.5f, 8.5f, 8.5f)
                reflectiveCurveToRelative(8.5f, -3.81f, 8.5f, -8.5f)
                verticalLineToRelative(-5.0f)
                curveTo(21.0f, 9.12f, 19.88f, 8.0f, 18.5f, 8.0f)
                close()
                moveTo(19.0f, 15.5f)
                curveToRelative(0.0f, 3.59f, -2.91f, 6.5f, -6.5f, 6.5f)
                reflectiveCurveTo(6.0f, 19.09f, 6.0f, 15.5f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveTo(7.0f, 6.72f, 7.0f, 7.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveTo(10.0f, 3.72f, 10.0f, 4.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(2.5f)
                curveTo(12.0f, 2.22f, 12.22f, 2.0f, 12.5f, 2.0f)
                reflectiveCurveTo(13.0f, 2.22f, 13.0f, 2.5f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.5f)
                curveTo(15.0f, 4.22f, 15.22f, 4.0f, 15.5f, 4.0f)
                reflectiveCurveTo(16.0f, 4.22f, 16.0f, 4.5f)
                verticalLineToRelative(8.92f)
                curveToRelative(-1.77f, 0.77f, -3.0f, 2.53f, -3.0f, 4.58f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -1.66f, 1.34f, -3.0f, 3.0f, -3.0f)
                verticalLineToRelative(-4.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineTo(15.5f)
                close()
            }
        }
        return _frontHand!!
    }

private var _frontHand: ImageVector? = null
