/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BrightnessLow: ImageVector
    get() {
        if (_brightnessLow != null) {
            return _brightnessLow!!
        }
        _brightnessLow = materialIcon(name = "Outlined.BrightnessLow") {
            materialPath {
                moveTo(20.0f, 8.69f)
                lineTo(20.0f, 4.0f)
                horizontalLineToRelative(-4.69f)
                lineTo(12.0f, 0.69f)
                lineTo(8.69f, 4.0f)
                lineTo(4.0f, 4.0f)
                verticalLineToRelative(4.69f)
                lineTo(0.69f, 12.0f)
                lineTo(4.0f, 15.31f)
                lineTo(4.0f, 20.0f)
                horizontalLineToRelative(4.69f)
                lineTo(12.0f, 23.31f)
                lineTo(15.31f, 20.0f)
                lineTo(20.0f, 20.0f)
                verticalLineToRelative(-4.69f)
                lineTo(23.31f, 12.0f)
                lineTo(20.0f, 8.69f)
                close()
                moveTo(18.0f, 14.48f)
                lineTo(18.0f, 18.0f)
                horizontalLineToRelative(-3.52f)
                lineTo(12.0f, 20.48f)
                lineTo(9.52f, 18.0f)
                lineTo(6.0f, 18.0f)
                verticalLineToRelative(-3.52f)
                lineTo(3.52f, 12.0f)
                lineTo(6.0f, 9.52f)
                lineTo(6.0f, 6.0f)
                horizontalLineToRelative(3.52f)
                lineTo(12.0f, 3.52f)
                lineTo(14.48f, 6.0f)
                lineTo(18.0f, 6.0f)
                verticalLineToRelative(3.52f)
                lineTo(20.48f, 12.0f)
                lineTo(18.0f, 14.48f)
                close()
                moveTo(12.0f, 6.0f)
                curveToRelative(-3.31f, 0.0f, -6.0f, 2.69f, -6.0f, 6.0f)
                reflectiveCurveToRelative(2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveToRelative(-2.69f, -6.0f, -6.0f, -6.0f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                close()
            }
        }
        return _brightnessLow!!
    }

private var _brightnessLow: ImageVector? = null
