/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Blind: ImageVector
    get() {
        if (_blind != null) {
            return _blind!!
        }
        _blind = materialIcon(name = "Outlined.Blind") {
            materialPath {
                moveTo(11.5f, 3.5f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(12.13f, 7.12f)
                curveToRelative(-0.17f, -0.35f, -0.44f, -0.65f, -0.8f, -0.85f)
                curveTo(10.72f, 5.91f, 9.99f, 5.93f, 9.4f, 6.24f)
                lineToRelative(0.0f, -0.01f)
                lineTo(4.0f, 9.3f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.54f)
                lineToRelative(1.5f, -0.85f)
                curveTo(7.18f, 10.71f, 7.0f, 11.85f, 7.0f, 13.0f)
                verticalLineToRelative(5.33f)
                lineTo(4.4f, 21.8f)
                lineTo(6.0f, 23.0f)
                lineToRelative(3.0f, -4.0f)
                lineToRelative(0.22f, -3.54f)
                lineTo(11.0f, 18.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.5f)
                lineToRelative(-1.97f, -2.81f)
                curveToRelative(-0.04f, -0.52f, -0.14f, -1.76f, 0.45f, -3.4f)
                curveToRelative(0.75f, 1.14f, 1.88f, 1.98f, 3.2f, 2.41f)
                lineTo(20.63f, 23.0f)
                lineToRelative(0.87f, -0.5f)
                lineTo(16.02f, 13.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-0.49f, 0.0f, -2.88f, 0.17f, -4.08f, -2.21f)
            }
        }
        return _blind!!
    }

private var _blind: ImageVector? = null
