/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AddToDrive: ImageVector
    get() {
        if (_addToDrive != null) {
            return _addToDrive!!
        }
        _addToDrive = materialIcon(name = "Outlined.AddToDrive") {
            materialPath {
                moveTo(19.0f, 11.0f)
                curveToRelative(0.17f, 0.0f, 0.33f, 0.01f, 0.49f, 0.02f)
                lineTo(15.0f, 3.0f)
                horizontalLineTo(9.0f)
                lineToRelative(5.68f, 9.84f)
                curveTo(15.77f, 11.71f, 17.3f, 11.0f, 19.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(8.15f, 4.52f)
                lineToRelative(-6.15f, 10.98f)
                lineToRelative(3.0f, 5.5f)
                lineToRelative(6.33f, -10.97f)
                close()
            }
            materialPath {
                moveTo(13.2f, 15.5f)
                horizontalLineTo(9.9f)
                lineTo(6.73f, 21.0f)
                horizontalLineToRelative(7.81f)
                curveTo(13.58f, 19.94f, 13.0f, 18.54f, 13.0f, 17.0f)
                curveTo(13.0f, 16.48f, 13.07f, 15.98f, 13.2f, 15.5f)
                close()
            }
            materialPath {
                moveTo(20.0f, 16.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                close()
            }
        }
        return _addToDrive!!
    }

private var _addToDrive: ImageVector? = null
