/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TireRepair: ImageVector
    get() {
        if (_tireRepair != null) {
            return _tireRepair!!
        }
        _tireRepair = materialIcon(name = "Filled.TireRepair") {
            materialPath {
                moveTo(18.0f, 7.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.28f, 0.0f, 0.53f, -0.11f, 0.71f, -0.29f)
                curveToRelative(0.4f, -0.4f, 1.04f, -2.46f, 1.04f, -2.46f)
                reflectiveCurveToRelative(-2.06f, 0.64f, -2.46f, 1.04f)
                curveTo(18.11f, 6.47f, 18.0f, 6.72f, 18.0f, 7.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 2.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                curveToRelative(0.0f, 2.05f, 1.23f, 3.81f, 3.0f, 4.58f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.65f, -1.35f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-0.35f, 0.0f, -0.69f, 0.06f, -1.0f, 0.17f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 3.0f, 2.0f, 3.9f, 2.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.65f, 1.35f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.35f, 3.0f, -3.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.42f)
                curveToRelative(1.77f, -0.77f, 3.0f, -2.53f, 3.0f, -4.58f)
                curveTo(24.0f, 4.24f, 21.76f, 2.0f, 19.0f, 2.0f)
                close()
                moveTo(6.0f, 19.5f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineToRelative(-2.83f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(19.5f)
                close()
                moveTo(6.0f, 14.5f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(9.67f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(14.5f)
                close()
                moveTo(6.0f, 9.5f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(4.67f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(9.5f)
                close()
                moveTo(10.0f, 17.5f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineToRelative(-2.83f)
                lineToRelative(2.0f, -2.0f)
                verticalLineTo(17.5f)
                close()
                moveTo(10.0f, 12.5f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineToRelative(-2.83f)
                lineToRelative(2.0f, -2.0f)
                verticalLineTo(12.5f)
                close()
                moveTo(10.0f, 7.5f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineTo(6.67f)
                lineToRelative(2.0f, -2.0f)
                verticalLineTo(7.5f)
                close()
                moveTo(19.0f, 10.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(20.66f, 10.0f, 19.0f, 10.0f)
                close()
            }
        }
        return _tireRepair!!
    }

private var _tireRepair: ImageVector? = null
