/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Filled.Grading",
    ReplaceWith( "Icons.AutoMirrored.Filled.Grading",
            "androidx.compose.material.icons.automirrored.filled.Grading"),
)
public val Icons.Filled.Grading: ImageVector
    get() {
        if (_grading != null) {
            return _grading!!
        }
        _grading = materialIcon(name = "Filled.Grading") {
            materialPath {
                moveTo(4.0f, 7.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(4.0f, 13.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(4.0f, 17.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(4.0f, 21.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(15.41f, 18.17f)
                lineTo(14.0f, 16.75f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(15.41f, 21.0f)
                lineTo(20.0f, 16.42f)
                lineTo(18.58f, 15.0f)
                lineTo(15.41f, 18.17f)
                close()
                moveTo(4.0f, 3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(4.0f)
                close()
            }
        }
        return _grading!!
    }

private var _grading: ImageVector? = null
