/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Rounded.FollowTheSigns: ImageVector
    get() {
        if (_followTheSigns != null) {
            return _followTheSigns!!
        }
        _followTheSigns = materialIcon(name = "AutoMirrored.Rounded.FollowTheSigns", autoMirror =
                true) {
            materialPath {
                moveTo(9.5f, 5.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(8.4f, 5.5f, 9.5f, 5.5f)
                close()
                moveTo(5.75f, 8.9f)
                lineTo(3.23f, 21.81f)
                curveTo(3.11f, 22.43f, 3.58f, 23.0f, 4.21f, 23.0f)
                horizontalLineTo(4.3f)
                curveToRelative(0.47f, 0.0f, 0.88f, -0.33f, 0.98f, -0.79f)
                lineTo(6.85f, 15.0f)
                lineTo(9.0f, 17.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-6.14f)
                curveToRelative(0.0f, -0.27f, -0.11f, -0.52f, -0.29f, -0.71f)
                lineTo(8.95f, 13.4f)
                lineToRelative(0.6f, -3.0f)
                curveToRelative(1.07f, 1.32f, 2.58f, 2.23f, 4.31f, 2.51f)
                curveToRelative(0.6f, 0.1f, 1.14f, -0.39f, 1.14f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.49f, -0.36f, -0.9f, -0.84f, -0.98f)
                curveToRelative(-1.49f, -0.25f, -2.75f, -1.15f, -3.51f, -2.38f)
                lineTo(9.7f, 6.95f)
                curveTo(9.35f, 6.35f, 8.7f, 6.0f, 8.0f, 6.0f)
                curveTo(7.75f, 6.0f, 7.5f, 6.05f, 7.25f, 6.15f)
                lineToRelative(-4.63f, 1.9f)
                curveTo(2.25f, 8.2f, 2.0f, 8.57f, 2.0f, 8.97f)
                verticalLineTo(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(9.65f)
                lineTo(5.75f, 8.9f)
                moveTo(21.0f, 2.0f)
                horizontalLineToRelative(-7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.75f)
                verticalLineToRelative(13.25f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(9.0f)
                horizontalLineTo(21.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(3.0f)
                curveTo(22.0f, 2.45f, 21.55f, 2.0f, 21.0f, 2.0f)
                close()
                moveTo(20.15f, 5.85f)
                lineToRelative(-1.28f, 1.29f)
                curveToRelative(-0.31f, 0.32f, -0.85f, 0.09f, -0.85f, -0.35f)
                verticalLineTo(6.25f)
                horizontalLineToRelative(-2.76f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                reflectiveCurveToRelative(0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineToRelative(2.76f)
                verticalLineTo(4.21f)
                curveToRelative(0.0f, -0.45f, 0.54f, -0.67f, 0.85f, -0.35f)
                lineToRelative(1.28f, 1.29f)
                curveTo(20.34f, 5.34f, 20.34f, 5.66f, 20.15f, 5.85f)
                close()
            }
        }
        return _followTheSigns!!
    }

private var _followTheSigns: ImageVector? = null
