/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.lint;

import androidx.compose.lint.KotlinUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.lint.UnreferencedParameter;
import androidx.compose.material.lint.MaterialNames;
import androidx.compose.material.lint.ScaffoldPaddingDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/material/lint/ScaffoldPaddingDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "material-lint"})
@SourceDebugExtension(value={"SMAP\nScaffoldPaddingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaffoldPaddingDetector.kt\nandroidx/compose/material/lint/ScaffoldPaddingDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n526#2:91\n511#2,6:92\n800#3,11:98\n1855#3:109\n1856#3:111\n1#4:110\n*S KotlinDebug\n*F\n+ 1 ScaffoldPaddingDetector.kt\nandroidx/compose/material/lint/ScaffoldPaddingDetector\n*L\n50#1:91\n50#1:92,6\n54#1:98,11\n57#1:109\n57#1:111\n*E\n"})
public final class ScaffoldPaddingDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnusedMaterialScaffoldPaddingParameter = Issue.Companion.create("UnusedMaterialScaffoldPaddingParameter", "Scaffold content should use the padding provided as a lambda parameter", "The `content` lambda in Scaffold has a padding parameter which will include any inner padding for the content due to app bars. If this parameter is ignored, then content may be obscured by the app bars resulting in visual issues or elements that can't be interacted with.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ScaffoldPaddingDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ScaffoldPaddingDetectorKt.access$getScaffold$p().getShortName());
    }

    /*
     * Unable to fully structure code
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block7: {
            if (!PsiUtilsKt.isInPackageName(method, MaterialNames.Material.INSTANCE.getPackageName())) break block7;
            v0 = Lint.computeKotlinArgumentMapping((UCallExpression)node, (PsiMethod)method);
            if (v0 == null) {
                v0 = MapsKt.emptyMap();
            }
            var6_4 = v0;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            var11_11 = $this$filterTo$iv$iv.entrySet().iterator();
            while (var11_11.hasNext()) {
                var13_13 = element$iv$iv = var11_11.next();
                $i$a$-filter-ScaffoldPaddingDetector$visitMethodCall$contentArgument$1 = false;
                parameter = (PsiParameter)var13_13.getValue();
                if (!Intrinsics.areEqual((Object)parameter.getName(), (Object)"content")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (Map.Entry<K, V> element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v1 = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (v1 == null) {
                return;
            }
            contentArgument = v1;
            $this$forEach$iv = KotlinUtilsKt.findUnreferencedParameters(contentArgument);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                unreferencedParameter = (UnreferencedParameter)element$iv;
                $i$a$-forEach-ScaffoldPaddingDetector$visitMethodCall$1 = false;
                var11_11 = unreferencedParameter.getParameter();
                if (var11_11 == null) ** GOTO lbl-1000
                it = var11_11;
                $i$a$-let-ScaffoldPaddingDetector$visitMethodCall$1$location$1 = false;
                var14_16 = context.getLocation((PsiElement)it);
                if (var14_16 != null) {
                    v2 = var14_16;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = context.getLocation((UElement)contentArgument);
                }
                location = v2;
                name = unreferencedParameter.getName();
                JavaContext.report$default((JavaContext)context, (Issue)ScaffoldPaddingDetector.UnusedMaterialScaffoldPaddingParameter, (UElement)((UElement)node), (Location)location, (String)("Content padding parameter " + name + " is not used"), null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/material/lint/ScaffoldPaddingDetector$Companion;", "", "()V", "UnusedMaterialScaffoldPaddingParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedMaterialScaffoldPaddingParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "material-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnusedMaterialScaffoldPaddingParameter() {
            return UnusedMaterialScaffoldPaddingParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

