/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.PreviewView;
import androidx.camera.view.preview.transform.ScaleTransform;
import androidx.camera.view.preview.transform.TranslationTransform;
import androidx.camera.view.preview.transform.transformation.ScaleTransformation;
import androidx.camera.view.preview.transform.transformation.Transformation;
import androidx.camera.view.preview.transform.transformation.TranslationTransformation;

final class ScaleTypeTransform {
    private ScaleTypeTransform() {
    }

    static Transformation getTransformation(@NonNull View container, @NonNull View view, @NonNull PreviewView.ScaleType scaleType, int deviceRotation) {
        ScaleTransformation scale = ScaleTypeTransform.getScale(container, view, scaleType, deviceRotation);
        Pair scaleXY = new Pair((Object)Float.valueOf(view.getScaleX() * scale.getScaleX()), (Object)Float.valueOf(view.getScaleY() * scale.getScaleY()));
        TranslationTransformation translation = ScaleTypeTransform.getScaledTranslation(container, view, scaleType, (Pair<Float, Float>)scaleXY, deviceRotation);
        return scale.add(translation);
    }

    private static ScaleTransformation getScale(@NonNull View container, @NonNull View view, @NonNull PreviewView.ScaleType scaleType, int deviceRotation) {
        switch (scaleType) {
            case FILL_START: 
            case FILL_CENTER: 
            case FILL_END: {
                return ScaleTransform.fill(container, view, deviceRotation);
            }
            case FIT_START: 
            case FIT_CENTER: 
            case FIT_END: {
                return ScaleTransform.fit(container, view, deviceRotation);
            }
        }
        throw new IllegalArgumentException("Unknown scale type " + (Object)((Object)scaleType));
    }

    private static TranslationTransformation getScaledTranslation(@NonNull View container, @NonNull View view, @NonNull PreviewView.ScaleType scaleType, @NonNull Pair<Float, Float> scaleXY, int deviceRotation) {
        switch (scaleType) {
            case FILL_START: 
            case FIT_START: {
                return TranslationTransform.start(view, scaleXY, deviceRotation);
            }
            case FILL_CENTER: 
            case FIT_CENTER: {
                return TranslationTransform.center(container, view);
            }
            case FILL_END: 
            case FIT_END: {
                return TranslationTransform.end(container, view, scaleXY, deviceRotation);
            }
        }
        throw new IllegalArgumentException("Unknown scale type " + (Object)((Object)scaleType));
    }
}

