/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.preview.transform.RotationTransform;
import androidx.camera.view.preview.transform.transformation.ScaleTransformation;

final class ScaleTransform {
    private ScaleTransform() {
    }

    static ScaleTransformation fill(@NonNull View container, @NonNull View view, int deviceRotation) {
        return ScaleTransform.computeScale(container, view, Math::max, deviceRotation);
    }

    static ScaleTransformation fit(@NonNull View container, @NonNull View view, int deviceRotation) {
        return ScaleTransform.computeScale(container, view, Math::min, deviceRotation);
    }

    private static ScaleTransformation computeScale(@NonNull View container, @NonNull View view, @NonNull FloatBiFunction function, int deviceRotation) {
        float bufferRotatedHeight;
        float bufferRotatedWidth;
        if (container.getWidth() == 0 || container.getHeight() == 0 || view.getWidth() == 0 || view.getHeight() == 0) {
            return new ScaleTransformation(1.0f);
        }
        int rotationDegrees = (int)RotationTransform.getRotationDegrees(view, deviceRotation);
        if (rotationDegrees == 0 || rotationDegrees == 180) {
            bufferRotatedWidth = (float)view.getWidth() * view.getScaleX();
            bufferRotatedHeight = (float)view.getHeight() * view.getScaleY();
        } else {
            bufferRotatedWidth = (float)view.getHeight() * view.getScaleY();
            bufferRotatedHeight = (float)view.getWidth() * view.getScaleX();
        }
        float scale = function.apply((float)container.getWidth() / bufferRotatedWidth, (float)container.getHeight() / bufferRotatedHeight);
        return new ScaleTransformation(scale);
    }

    private static interface FloatBiFunction {
        public float apply(float var1, float var2);
    }
}

