/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProcessor;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class InternalImageProcessor {
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final ImageProcessor mImageProcessor;

    public InternalImageProcessor(@NonNull CameraEffect cameraEffect) {
        Preconditions.checkArgument((cameraEffect.getTargets() == 4 ? 1 : 0) != 0);
        this.mExecutor = cameraEffect.getProcessorExecutor();
        this.mImageProcessor = Objects.requireNonNull(cameraEffect.getImageProcessor());
    }

    @NonNull
    public ImageProcessor.Response safeProcess(@NonNull ImageProcessor.Request request) throws ImageCaptureException {
        try {
            return (ImageProcessor.Response)CallbackToFutureAdapter.getFuture(completer -> {
                this.mExecutor.execute(() -> {
                    try {
                        completer.set((Object)this.mImageProcessor.process(request));
                    }
                    catch (Exception e) {
                        completer.setException((Throwable)e);
                    }
                });
                return "InternalImageProcessor#process " + request.hashCode();
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new ImageCaptureException(0, "Failed to invoke ImageProcessor.", cause);
        }
    }
}

