/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat;

import android.media.ImageWriter;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=26)
final class ImageWriterCompatApi26Impl {
    private static final String TAG = "ImageWriterCompatApi26";
    private static Method sNewInstanceMethod;

    @NonNull
    static ImageWriter newInstance(@NonNull Surface surface, @IntRange(from=1L) int maxImages, int format) {
        ReflectiveOperationException t = null;
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                return (ImageWriter)Preconditions.checkNotNull((Object)sNewInstanceMethod.invoke(null, surface, maxImages, format));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                t = e;
            }
        }
        throw new RuntimeException("Unable to invoke newInstance(Surface, int, int) via reflection.", t);
    }

    private ImageWriterCompatApi26Impl() {
    }

    static {
        try {
            sNewInstanceMethod = ImageWriter.class.getMethod("newInstance", Surface.class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            Log.i((String)TAG, (String)"Unable to initialize via reflection.", (Throwable)e);
        }
    }
}

