/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraRepository;

@RequiresApi(value=21)
public final class CameraValidator {
    private static final String TAG = "CameraValidator";

    private CameraValidator() {
    }

    public static void validateCameras(@NonNull Context context, @NonNull CameraRepository cameraRepository, @Nullable CameraSelector availableCamerasSelector) throws CameraIdListIncorrectException {
        Integer lensFacing = null;
        try {
            if (availableCamerasSelector != null && (lensFacing = availableCamerasSelector.getLensFacing()) == null) {
                Logger.w(TAG, "No lens facing info in the availableCamerasSelector, don't verify the camera lens facing.");
                return;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "Cannot get lens facing from the availableCamerasSelector don't verify the camera lens facing.", e);
            return;
        }
        Logger.d(TAG, "Verifying camera lens facing on " + Build.DEVICE + ", lensFacingInteger: " + lensFacing);
        PackageManager pm = context.getPackageManager();
        try {
            if (pm.hasSystemFeature("android.hardware.camera") && (availableCamerasSelector == null || lensFacing == 1)) {
                CameraSelector.DEFAULT_BACK_CAMERA.select(cameraRepository.getCameras());
            }
            if (pm.hasSystemFeature("android.hardware.camera.front") && (availableCamerasSelector == null || lensFacing == 0)) {
                CameraSelector.DEFAULT_FRONT_CAMERA.select(cameraRepository.getCameras());
            }
        }
        catch (IllegalArgumentException e) {
            Logger.e(TAG, "Camera LensFacing verification failed, existing cameras: " + cameraRepository.getCameras());
            throw new CameraIdListIncorrectException("Expected camera missing from device.", e);
        }
    }

    public static class CameraIdListIncorrectException
    extends Exception {
        public CameraIdListIncorrectException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }
}

