/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.CameraRequest;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.RequestWithCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

@RequiresApi(api=21)
public class TakePictureManager
implements ForwardingImageProxy.OnImageCloseListener {
    private static final String TAG = "TakePictureManager";
    @VisibleForTesting
    final Deque<TakePictureRequest> mNewRequests = new ArrayDeque<TakePictureRequest>();
    final ImagePipeline mImagePipeline;
    final ImageCaptureControl mImageCaptureControl;
    @VisibleForTesting
    @Nullable
    RequestWithCallback mInFlightRequest;
    boolean mPaused = false;

    @MainThread
    public TakePictureManager(@NonNull ImageCaptureControl imageCaptureControl, @NonNull ImagePipeline imagePipeline) {
        Threads.checkMainThread();
        this.mImageCaptureControl = imageCaptureControl;
        this.mImagePipeline = imagePipeline;
        this.mImagePipeline.setOnImageCloseListener(this);
    }

    @MainThread
    public void offerRequest(@NonNull TakePictureRequest takePictureRequest) {
        Threads.checkMainThread();
        this.mNewRequests.offer(takePictureRequest);
        this.issueNextRequest();
    }

    @MainThread
    public void pause() {
        Threads.checkMainThread();
        this.mPaused = true;
    }

    @MainThread
    public void resume() {
        Threads.checkMainThread();
        this.mPaused = false;
        this.issueNextRequest();
    }

    @MainThread
    public void abortRequests() {
        Threads.checkMainThread();
        ImageCaptureException exception = new ImageCaptureException(3, "Camera is closed.", null);
        for (TakePictureRequest request : this.mNewRequests) {
            request.onError(exception);
        }
        this.mNewRequests.clear();
        if (this.mInFlightRequest != null) {
            this.mInFlightRequest.abort(exception);
        }
    }

    @MainThread
    void issueNextRequest() {
        Threads.checkMainThread();
        Log.d((String)TAG, (String)"Issue the next TakePictureRequest.");
        if (this.hasInFlightRequest()) {
            Log.d((String)TAG, (String)"There is already a request in-flight.");
            return;
        }
        if (this.mPaused) {
            Log.d((String)TAG, (String)"The class is paused.");
            return;
        }
        if (this.mImagePipeline.getCapacity() == 0) {
            Log.d((String)TAG, (String)"Too many acquire images. Close image to be able to process next.");
            return;
        }
        TakePictureRequest request = this.mNewRequests.poll();
        if (request == null) {
            Log.d((String)TAG, (String)"No new request.");
            return;
        }
        RequestWithCallback requestWithCallback = new RequestWithCallback(request);
        this.trackCurrentRequest(requestWithCallback);
        Pair<CameraRequest, ProcessingRequest> requests = this.mImagePipeline.createRequests(request, requestWithCallback);
        CameraRequest cameraRequest = Objects.requireNonNull((CameraRequest)requests.first);
        ProcessingRequest processingRequest = Objects.requireNonNull((ProcessingRequest)requests.second);
        this.submitCameraRequest(cameraRequest, () -> this.mImagePipeline.postProcess(processingRequest));
    }

    private void trackCurrentRequest(@NonNull RequestWithCallback requestWithCallback) {
        Preconditions.checkState((!this.hasInFlightRequest() ? 1 : 0) != 0);
        this.mInFlightRequest = requestWithCallback;
        this.mInFlightRequest.getCaptureFuture().addListener(() -> {
            this.mInFlightRequest = null;
            this.issueNextRequest();
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    private void submitCameraRequest(final @NonNull CameraRequest cameraRequest, final @NonNull Runnable successRunnable) {
        Threads.checkMainThread();
        this.mImageCaptureControl.lockFlashMode();
        ListenableFuture<Void> submitRequestFuture = this.mImageCaptureControl.submitStillCaptureRequests(cameraRequest.getCaptureConfigs());
        Futures.addCallback(submitRequestFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                successRunnable.run();
                TakePictureManager.this.mImageCaptureControl.unlockFlashMode();
            }

            @Override
            public void onFailure(@NonNull Throwable throwable) {
                if (throwable instanceof ImageCaptureException) {
                    cameraRequest.onCaptureFailure((ImageCaptureException)throwable);
                } else {
                    cameraRequest.onCaptureFailure(new ImageCaptureException(2, "Failed to submit capture request", throwable));
                }
                TakePictureManager.this.mImageCaptureControl.unlockFlashMode();
            }
        }, CameraXExecutors.mainThreadExecutor());
    }

    @VisibleForTesting
    boolean hasInFlightRequest() {
        return this.mInFlightRequest != null;
    }

    @Override
    public void onImageClose(@NonNull ImageProxy image) {
        CameraXExecutors.mainThreadExecutor().execute(this::issueNextRequest);
    }
}

