/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.quirk.AspectRatioLegacyApi21Quirk;
import androidx.camera.camera2.internal.compat.quirk.CameraQuirks;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.Nexus4AndroidLTargetAspectRatioQuirk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
public class TargetAspectRatio {
    public static final int RATIO_4_3 = 0;
    public static final int RATIO_16_9 = 1;
    public static final int RATIO_MAX_JPEG = 2;
    public static final int RATIO_ORIGINAL = 3;

    public int get(@NonNull String cameraId, @NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        Nexus4AndroidLTargetAspectRatioQuirk nexus4AndroidLQuirk = DeviceQuirks.get(Nexus4AndroidLTargetAspectRatioQuirk.class);
        if (nexus4AndroidLQuirk != null) {
            return nexus4AndroidLQuirk.getCorrectedAspectRatio();
        }
        AspectRatioLegacyApi21Quirk quirk = (AspectRatioLegacyApi21Quirk)CameraQuirks.get(cameraId, cameraCharacteristicsCompat).get(AspectRatioLegacyApi21Quirk.class);
        if (quirk != null) {
            return quirk.getCorrectedAspectRatio();
        }
        return 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Ratio {
    }
}

