/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.ExtraCroppingQuirk;
import androidx.camera.core.impl.SurfaceConfig;

@RequiresApi(value=21)
public class MaxPreviewSize {
    @Nullable
    private final ExtraCroppingQuirk mExtraCroppingQuirk;

    public MaxPreviewSize() {
        this(DeviceQuirks.get(ExtraCroppingQuirk.class));
    }

    @VisibleForTesting
    MaxPreviewSize(@Nullable ExtraCroppingQuirk extraCroppingQuirk) {
        this.mExtraCroppingQuirk = extraCroppingQuirk;
    }

    @NonNull
    public Size getMaxPreviewResolution(@NonNull Size defaultMaxPreviewResolution) {
        if (this.mExtraCroppingQuirk == null) {
            return defaultMaxPreviewResolution;
        }
        Size selectResolution = this.mExtraCroppingQuirk.getVerifiedResolution(SurfaceConfig.ConfigType.PRIV);
        if (selectResolution == null) {
            return defaultMaxPreviewResolution;
        }
        boolean isSelectResolutionLarger = selectResolution.getWidth() * selectResolution.getHeight() > defaultMaxPreviewResolution.getWidth() * defaultMaxPreviewResolution.getHeight();
        return isSelectResolutionLarger ? selectResolution : defaultMaxPreviewResolution;
    }
}

