/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.Logger;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
class CameraDeviceCompatBaseImpl
implements CameraDeviceCompat.CameraDeviceCompatImpl {
    final CameraDevice mCameraDevice;
    final Object mImplParams;

    CameraDeviceCompatBaseImpl(@NonNull CameraDevice cameraDevice, @Nullable Object implParams) {
        this.mCameraDevice = (CameraDevice)Preconditions.checkNotNull((Object)cameraDevice);
        this.mImplParams = implParams;
    }

    static CameraDeviceCompatBaseImpl create(@NonNull CameraDevice cameraDevice, @NonNull Handler compatHandler) {
        return new CameraDeviceCompatBaseImpl(cameraDevice, new CameraDeviceCompatParamsApi21(compatHandler));
    }

    static List<Surface> unpackSurfaces(@NonNull List<OutputConfigurationCompat> outputConfigs) {
        ArrayList<Surface> surfaces = new ArrayList<Surface>(outputConfigs.size());
        for (OutputConfigurationCompat outputConfig : outputConfigs) {
            surfaces.add(outputConfig.getSurface());
        }
        return surfaces;
    }

    static void checkPreconditions(CameraDevice device, SessionConfigurationCompat config) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)config.getStateCallback());
        List<OutputConfigurationCompat> outputConfigs = config.getOutputConfigurations();
        if (outputConfigs == null) {
            throw new IllegalArgumentException("Invalid output configurations");
        }
        if (config.getExecutor() == null) {
            throw new IllegalArgumentException("Invalid executor");
        }
        CameraDeviceCompatBaseImpl.checkPhysicalCameraIdValid(device, outputConfigs);
    }

    private static void checkPhysicalCameraIdValid(CameraDevice device, @NonNull List<OutputConfigurationCompat> outputConfigs) {
        String cameraId = device.getId();
        for (OutputConfigurationCompat outputConfigurationCompat : outputConfigs) {
            String outputConfigPhysicalId = outputConfigurationCompat.getPhysicalCameraId();
            if (outputConfigPhysicalId == null || outputConfigPhysicalId.isEmpty()) continue;
            Logger.w((String)"CameraDeviceCompat", (String)("Camera " + cameraId + ": Camera doesn't support physicalCameraId " + outputConfigPhysicalId + ". Ignoring."));
        }
    }

    void createBaseCaptureSession(@NonNull CameraDevice device, @NonNull List<Surface> surfaces, @NonNull CameraCaptureSession.StateCallback cb, @NonNull Handler handler) throws CameraAccessExceptionCompat {
        try {
            device.createCaptureSession(surfaces, cb, handler);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }

    @Override
    public void createCaptureSession(@NonNull SessionConfigurationCompat config) throws CameraAccessExceptionCompat {
        CameraDeviceCompatBaseImpl.checkPreconditions(this.mCameraDevice, config);
        if (config.getInputConfiguration() != null) {
            throw new IllegalArgumentException("Reprocessing sessions not supported until API 23");
        }
        if (config.getSessionType() == 1) {
            throw new IllegalArgumentException("High speed capture sessions not supported until API 23");
        }
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<Surface> surfaces = CameraDeviceCompatBaseImpl.unpackSurfaces(config.getOutputConfigurations());
        CameraDeviceCompatParamsApi21 params = (CameraDeviceCompatParamsApi21)this.mImplParams;
        this.createBaseCaptureSession(this.mCameraDevice, surfaces, cb, params.mCompatHandler);
    }

    @Override
    @NonNull
    public CameraDevice unwrap() {
        return this.mCameraDevice;
    }

    static class CameraDeviceCompatParamsApi21 {
        final Handler mCompatHandler;

        CameraDeviceCompatParamsApi21(@NonNull Handler compatHandler) {
            this.mCompatHandler = compatHandler;
        }
    }
}

