/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.Camera2RequestProcessor;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.camera2.internal.CaptureSessionInterface;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionOpener;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.DeferrableSurfaces;
import androidx.camera.core.impl.OutputSurface;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.SessionProcessorSurface;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RequiresApi(value=21)
@OptIn(markerClass={ExperimentalCamera2Interop.class})
final class ProcessingCaptureSession
implements CaptureSessionInterface {
    private static final String TAG = "ProcessingCaptureSession";
    private final SessionProcessor mSessionProcessor;
    private final Camera2CameraInfoImpl mCamera2CameraInfoImpl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduledExecutorService;
    private final CaptureSession mCaptureSession;
    private List<DeferrableSurface> mOutputSurfaces = new ArrayList<DeferrableSurface>();
    @Nullable
    private SessionConfig mSessionConfig;
    @Nullable
    private Camera2RequestProcessor mRequestProcessor;
    @Nullable
    private SessionConfig mProcessorSessionConfig;
    private static final long TIMEOUT_GET_SURFACE_IN_MS = 5000L;
    private ProcessorState mProcessorState;
    private static List<DeferrableSurface> sHeldProcessorSurfaces = new ArrayList<DeferrableSurface>();
    @Nullable
    private volatile CaptureConfig mPendingCaptureConfig = null;
    volatile boolean mIsExecutingStillCaptureRequest = false;
    private final SessionProcessorCaptureCallback mSessionProcessorCaptureCallback;
    private CaptureRequestOptions mSessionOptions = new CaptureRequestOptions.Builder().build();
    private CaptureRequestOptions mStillCaptureOptions = new CaptureRequestOptions.Builder().build();
    private static int sNextInstanceId = 0;
    private int mInstanceId = 0;

    ProcessingCaptureSession(@NonNull SessionProcessor sessionProcessor, @NonNull Camera2CameraInfoImpl camera2CameraInfoImpl, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.mCaptureSession = new CaptureSession();
        this.mSessionProcessor = sessionProcessor;
        this.mCamera2CameraInfoImpl = camera2CameraInfoImpl;
        this.mExecutor = executor;
        this.mScheduledExecutorService = scheduledExecutorService;
        this.mProcessorState = ProcessorState.UNINITIALIZED;
        this.mSessionProcessorCaptureCallback = new SessionProcessorCaptureCallback();
        this.mInstanceId = sNextInstanceId++;
        Logger.d((String)TAG, (String)("New ProcessingCaptureSession (id=" + this.mInstanceId + ")"));
    }

    @Override
    @NonNull
    public ListenableFuture<Void> open(@NonNull SessionConfig sessionConfig, @NonNull CameraDevice cameraDevice, @NonNull SynchronizedCaptureSessionOpener opener) {
        Preconditions.checkArgument((this.mProcessorState == ProcessorState.UNINITIALIZED ? 1 : 0) != 0, (Object)("Invalid state state:" + (Object)((Object)this.mProcessorState)));
        Preconditions.checkArgument((!sessionConfig.getSurfaces().isEmpty() ? 1 : 0) != 0, (Object)"SessionConfig contains no surfaces");
        Logger.d((String)TAG, (String)("open (id=" + this.mInstanceId + ")"));
        this.mOutputSurfaces = sessionConfig.getSurfaces();
        FutureChain future = FutureChain.from((ListenableFuture)DeferrableSurfaces.surfaceListWithTimeout(this.mOutputSurfaces, (boolean)false, (long)5000L, (Executor)this.mExecutor, (ScheduledExecutorService)this.mScheduledExecutorService)).transformAsync(surfaceList -> {
            Logger.d((String)TAG, (String)("-- getSurfaces done, start init (id=" + this.mInstanceId + ")"));
            if (this.mProcessorState == ProcessorState.CLOSED) {
                return Futures.immediateFailedFuture((Throwable)new IllegalStateException("SessionProcessorCaptureSession is closed."));
            }
            if (surfaceList.contains(null)) {
                DeferrableSurface deferrableSurface = (DeferrableSurface)sessionConfig.getSurfaces().get(surfaceList.indexOf(null));
                return Futures.immediateFailedFuture((Throwable)new DeferrableSurface.SurfaceClosedException("Surface closed", deferrableSurface));
            }
            try {
                DeferrableSurfaces.incrementAll(this.mOutputSurfaces);
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            OutputSurface previewOutputSurface = null;
            OutputSurface captureOutputSurface = null;
            OutputSurface analysisOutputSurface = null;
            for (int i = 0; i < sessionConfig.getSurfaces().size(); ++i) {
                DeferrableSurface dSurface = (DeferrableSurface)sessionConfig.getSurfaces().get(i);
                if (Objects.equals(dSurface.getContainerClass(), Preview.class)) {
                    previewOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)new Size(dSurface.getPrescribedSize().getWidth(), dSurface.getPrescribedSize().getHeight()), (int)dSurface.getPrescribedStreamFormat());
                    continue;
                }
                if (Objects.equals(dSurface.getContainerClass(), ImageCapture.class)) {
                    captureOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)new Size(dSurface.getPrescribedSize().getWidth(), dSurface.getPrescribedSize().getHeight()), (int)dSurface.getPrescribedStreamFormat());
                    continue;
                }
                if (!Objects.equals(dSurface.getContainerClass(), ImageAnalysis.class)) continue;
                analysisOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)new Size(dSurface.getPrescribedSize().getWidth(), dSurface.getPrescribedSize().getHeight()), (int)dSurface.getPrescribedStreamFormat());
            }
            this.mProcessorState = ProcessorState.SESSION_INITIALIZED;
            Logger.w((String)TAG, (String)("== initSession (id=" + this.mInstanceId + ")"));
            this.mProcessorSessionConfig = this.mSessionProcessor.initSession((CameraInfo)this.mCamera2CameraInfoImpl, previewOutputSurface, captureOutputSurface, analysisOutputSurface);
            ((DeferrableSurface)this.mProcessorSessionConfig.getSurfaces().get(0)).getTerminationFuture().addListener(() -> DeferrableSurfaces.decrementAll(this.mOutputSurfaces), CameraXExecutors.directExecutor());
            for (DeferrableSurface surface : this.mProcessorSessionConfig.getSurfaces()) {
                sHeldProcessorSurfaces.add(surface);
                surface.getTerminationFuture().addListener(() -> sHeldProcessorSurfaces.remove(surface), this.mExecutor);
            }
            SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
            validatingBuilder.add(sessionConfig);
            validatingBuilder.clearSurfaces();
            validatingBuilder.add(this.mProcessorSessionConfig);
            Preconditions.checkArgument((boolean)validatingBuilder.isValid(), (Object)"Cannot transform the SessionConfig");
            SessionConfig transformedConfig = validatingBuilder.build();
            ListenableFuture<Void> openSessionFuture = this.mCaptureSession.open(transformedConfig, (CameraDevice)Preconditions.checkNotNull((Object)cameraDevice), opener);
            Futures.addCallback(openSessionFuture, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                }

                public void onFailure(@NonNull Throwable t) {
                    Logger.e((String)ProcessingCaptureSession.TAG, (String)"open session failed ", (Throwable)t);
                    ProcessingCaptureSession.this.close();
                }
            }, (Executor)this.mExecutor);
            return openSessionFuture;
        }, this.mExecutor).transform(v -> {
            this.onConfigured(this.mCaptureSession);
            return null;
        }, this.mExecutor);
        return future;
    }

    private static void cancelRequests(@NonNull List<CaptureConfig> captureConfigs) {
        for (CaptureConfig captureConfig : captureConfigs) {
            for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                cameraCaptureCallback.onCaptureCancelled();
            }
        }
    }

    private boolean isStillCapture(@NonNull List<CaptureConfig> captureConfigs) {
        if (captureConfigs.isEmpty()) {
            return false;
        }
        for (CaptureConfig captureConfig : captureConfigs) {
            if (captureConfig.getTemplateType() == 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void issueCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        if (captureConfigs.isEmpty()) {
            return;
        }
        if (captureConfigs.size() > 1 || !this.isStillCapture(captureConfigs)) {
            ProcessingCaptureSession.cancelRequests(captureConfigs);
            return;
        }
        if (this.mPendingCaptureConfig != null || this.mIsExecutingStillCaptureRequest) {
            ProcessingCaptureSession.cancelRequests(captureConfigs);
            return;
        }
        final CaptureConfig captureConfig = captureConfigs.get(0);
        Logger.d((String)TAG, (String)("issueCaptureRequests (id=" + this.mInstanceId + ") + state =" + (Object)((Object)this.mProcessorState)));
        switch (this.mProcessorState) {
            case UNINITIALIZED: 
            case SESSION_INITIALIZED: {
                this.mPendingCaptureConfig = captureConfig;
                break;
            }
            case ON_CAPTURE_SESSION_STARTED: {
                this.mIsExecutingStillCaptureRequest = true;
                CaptureRequestOptions.Builder builder = CaptureRequestOptions.Builder.from(captureConfig.getImplementationOptions());
                if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_ROTATION)) {
                    builder.setCaptureRequestOption(CaptureRequest.JPEG_ORIENTATION, (Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_ROTATION));
                }
                if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_JPEG_QUALITY)) {
                    builder.setCaptureRequestOption(CaptureRequest.JPEG_QUALITY, ((Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_JPEG_QUALITY)).byteValue());
                }
                this.mStillCaptureOptions = builder.build();
                this.updateParameters(this.mSessionOptions, this.mStillCaptureOptions);
                this.mSessionProcessor.startCapture(new SessionProcessor.CaptureCallback(){

                    public void onCaptureStarted(int captureSequenceId, long timestamp) {
                    }

                    public void onCaptureProcessStarted(int captureSequenceId) {
                    }

                    public void onCaptureFailed(int captureSequenceId) {
                        ProcessingCaptureSession.this.mExecutor.execute(() -> {
                            for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                                cameraCaptureCallback.onCaptureFailed(new CameraCaptureFailure(CameraCaptureFailure.Reason.ERROR));
                            }
                            ProcessingCaptureSession.this.mIsExecutingStillCaptureRequest = false;
                        });
                    }

                    public void onCaptureSequenceCompleted(int captureSequenceId) {
                        ProcessingCaptureSession.this.mExecutor.execute(() -> {
                            for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                                cameraCaptureCallback.onCaptureCompleted((CameraCaptureResult)new CameraCaptureResult.EmptyCameraCaptureResult());
                            }
                            ProcessingCaptureSession.this.mIsExecutingStillCaptureRequest = false;
                        });
                    }

                    public void onCaptureSequenceAborted(int captureSequenceId) {
                    }

                    public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull Map<CaptureResult.Key, Object> result) {
                    }
                });
                break;
            }
            case ON_CAPTURE_SESSION_ENDED: 
            case CLOSED: {
                Logger.d((String)TAG, (String)("Run issueCaptureRequests in wrong state, state = " + (Object)((Object)this.mProcessorState)));
                ProcessingCaptureSession.cancelRequests(captureConfigs);
            }
        }
    }

    @Override
    @NonNull
    public ListenableFuture<Void> release(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mProcessorState == ProcessorState.CLOSED ? 1 : 0) != 0, (String)"release() can only be called in CLOSED state");
        Logger.d((String)TAG, (String)("release (id=" + this.mInstanceId + ")"));
        return this.mCaptureSession.release(abortInFlightCaptures);
    }

    private static List<SessionProcessorSurface> getSessionProcessorSurfaceList(List<DeferrableSurface> deferrableSurfaceList) {
        ArrayList<SessionProcessorSurface> outputSurfaceList = new ArrayList<SessionProcessorSurface>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaceList) {
            Preconditions.checkArgument((boolean)(deferrableSurface instanceof SessionProcessorSurface), (Object)"Surface must be SessionProcessorSurface");
            outputSurfaceList.add((SessionProcessorSurface)deferrableSurface);
        }
        return outputSurfaceList;
    }

    void onConfigured(@NonNull CaptureSession captureSession) {
        Preconditions.checkArgument((this.mProcessorState == ProcessorState.SESSION_INITIALIZED ? 1 : 0) != 0, (Object)("Invalid state state:" + (Object)((Object)this.mProcessorState)));
        this.mRequestProcessor = new Camera2RequestProcessor(captureSession, ProcessingCaptureSession.getSessionProcessorSurfaceList(this.mProcessorSessionConfig.getSurfaces()));
        this.mSessionProcessor.onCaptureSessionStart((RequestProcessor)this.mRequestProcessor);
        this.mProcessorState = ProcessorState.ON_CAPTURE_SESSION_STARTED;
        if (this.mSessionConfig != null) {
            this.setSessionConfig(this.mSessionConfig);
        }
        if (this.mPendingCaptureConfig != null) {
            List<CaptureConfig> pendingCaptureConfigList = Arrays.asList(this.mPendingCaptureConfig);
            this.mPendingCaptureConfig = null;
            this.issueCaptureRequests(pendingCaptureConfigList);
        }
    }

    @Override
    @Nullable
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    @NonNull
    public List<CaptureConfig> getCaptureConfigs() {
        return this.mPendingCaptureConfig != null ? Arrays.asList(this.mPendingCaptureConfig) : Collections.emptyList();
    }

    @Override
    public void cancelIssuedCaptureRequests() {
        Logger.d((String)TAG, (String)("cancelIssuedCaptureRequests (id=" + this.mInstanceId + ")"));
        if (this.mPendingCaptureConfig != null) {
            for (CameraCaptureCallback cameraCaptureCallback : this.mPendingCaptureConfig.getCameraCaptureCallbacks()) {
                cameraCaptureCallback.onCaptureCancelled();
            }
            this.mPendingCaptureConfig = null;
        }
    }

    @Override
    public void close() {
        Logger.d((String)TAG, (String)("close (id=" + this.mInstanceId + ") state=" + (Object)((Object)this.mProcessorState)));
        switch (this.mProcessorState) {
            case ON_CAPTURE_SESSION_STARTED: {
                this.mSessionProcessor.onCaptureSessionEnd();
                if (this.mRequestProcessor != null) {
                    this.mRequestProcessor.close();
                }
                this.mProcessorState = ProcessorState.ON_CAPTURE_SESSION_ENDED;
            }
            case SESSION_INITIALIZED: 
            case ON_CAPTURE_SESSION_ENDED: {
                this.mSessionProcessor.deInitSession();
                break;
            }
            case UNINITIALIZED: {
                break;
            }
            case CLOSED: {
                return;
            }
        }
        this.mProcessorState = ProcessorState.CLOSED;
        this.mCaptureSession.close();
    }

    @Override
    public void setSessionConfig(@Nullable SessionConfig sessionConfig) {
        Logger.d((String)TAG, (String)("setSessionConfig (id=" + this.mInstanceId + ")"));
        this.mSessionConfig = sessionConfig;
        if (sessionConfig == null) {
            return;
        }
        if (this.mRequestProcessor != null) {
            this.mRequestProcessor.updateSessionConfig(sessionConfig);
        }
        if (this.mProcessorState == ProcessorState.ON_CAPTURE_SESSION_STARTED) {
            this.mSessionOptions = CaptureRequestOptions.Builder.from(sessionConfig.getImplementationOptions()).build();
            this.updateParameters(this.mSessionOptions, this.mStillCaptureOptions);
            this.mSessionProcessor.startRepeating((SessionProcessor.CaptureCallback)this.mSessionProcessorCaptureCallback);
        }
    }

    private void updateParameters(@NonNull CaptureRequestOptions sessionOptions, @NonNull CaptureRequestOptions stillCaptureOptions) {
        Camera2ImplConfig.Builder builder = new Camera2ImplConfig.Builder();
        builder.insertAllOptions((Config)sessionOptions);
        builder.insertAllOptions((Config)stillCaptureOptions);
        this.mSessionProcessor.setParameters((Config)builder.build());
    }

    private static class SessionProcessorCaptureCallback
    implements SessionProcessor.CaptureCallback {
        SessionProcessorCaptureCallback() {
        }

        public void onCaptureStarted(int captureSequenceId, long timestamp) {
        }

        public void onCaptureProcessStarted(int captureSequenceId) {
        }

        public void onCaptureFailed(int captureSequenceId) {
        }

        public void onCaptureSequenceCompleted(int captureSequenceId) {
        }

        public void onCaptureSequenceAborted(int captureSequenceId) {
        }

        public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull Map<CaptureResult.Key, Object> result) {
        }
    }

    private static enum ProcessorState {
        UNINITIALIZED,
        SESSION_INITIALIZED,
        ON_CAPTURE_SESSION_STARTED,
        ON_CAPTURE_SESSION_ENDED,
        CLOSED;

    }
}

