/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.AutoValue_Camera2CameraImpl_UseCaseInfo;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.CameraDeviceStateCallbacks;
import androidx.camera.camera2.internal.CameraStateMachine;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.camera2.internal.CaptureSessionInterface;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.MeteringRepeatingSession;
import androidx.camera.camera2.internal.ProcessingCaptureSession;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionOpener;
import androidx.camera.camera2.internal.compat.ApiCompat;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraState;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraStateRegistry;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.UseCaseAttachState;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

@RequiresApi(value=21)
final class Camera2CameraImpl
implements CameraInternal {
    private static final String TAG = "Camera2CameraImpl";
    private static final int ERROR_NONE = 0;
    private final UseCaseAttachState mUseCaseAttachState;
    private final CameraManagerCompat mCameraManager;
    private final Executor mExecutor;
    private final ScheduledExecutorService mScheduledExecutorService;
    volatile InternalState mState = InternalState.INITIALIZED;
    private final LiveDataObservable<CameraInternal.State> mObservableState = new LiveDataObservable();
    private final CameraStateMachine mCameraStateMachine;
    private final Camera2CameraControlImpl mCameraControlInternal;
    private final StateCallback mStateCallback;
    @NonNull
    final Camera2CameraInfoImpl mCameraInfoInternal;
    @Nullable
    CameraDevice mCameraDevice;
    int mCameraDeviceError = 0;
    CaptureSessionInterface mCaptureSession;
    final AtomicInteger mReleaseRequestCount = new AtomicInteger(0);
    ListenableFuture<Void> mUserReleaseFuture;
    CallbackToFutureAdapter.Completer<Void> mUserReleaseNotifier;
    final Map<CaptureSessionInterface, ListenableFuture<Void>> mReleasedCaptureSessions = new LinkedHashMap<CaptureSessionInterface, ListenableFuture<Void>>();
    private final CameraAvailability mCameraAvailability;
    private final CameraStateRegistry mCameraStateRegistry;
    final Set<CaptureSession> mConfiguringForClose = new HashSet<CaptureSession>();
    private MeteringRepeatingSession mMeteringRepeatingSession;
    @NonNull
    private final CaptureSessionRepository mCaptureSessionRepository;
    @NonNull
    private final SynchronizedCaptureSessionOpener.Builder mCaptureSessionOpenerBuilder;
    private final Set<String> mNotifyStateAttachedSet = new HashSet<String>();
    @NonNull
    private CameraConfig mCameraConfig = CameraConfigs.emptyConfig();
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private SessionProcessor mSessionProcessor;
    boolean mIsActiveResumingMode = false;
    @NonNull
    private final DisplayInfoManager mDisplayInfoManager;

    Camera2CameraImpl(@NonNull CameraManagerCompat cameraManager, @NonNull String cameraId, @NonNull Camera2CameraInfoImpl cameraInfoImpl, @NonNull CameraStateRegistry cameraStateRegistry, @NonNull Executor executor, @NonNull Handler schedulerHandler, @NonNull DisplayInfoManager displayInfoManager) throws CameraUnavailableException {
        this.mCameraManager = cameraManager;
        this.mCameraStateRegistry = cameraStateRegistry;
        this.mScheduledExecutorService = CameraXExecutors.newHandlerExecutor((Handler)schedulerHandler);
        this.mExecutor = CameraXExecutors.newSequentialExecutor((Executor)executor);
        this.mStateCallback = new StateCallback(this.mExecutor, this.mScheduledExecutorService);
        this.mUseCaseAttachState = new UseCaseAttachState(cameraId);
        this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
        this.mCameraStateMachine = new CameraStateMachine(cameraStateRegistry);
        this.mCaptureSessionRepository = new CaptureSessionRepository(this.mExecutor);
        this.mDisplayInfoManager = displayInfoManager;
        this.mCaptureSession = this.newCaptureSession();
        try {
            CameraCharacteristicsCompat cameraCharacteristicsCompat = this.mCameraManager.getCameraCharacteristicsCompat(cameraId);
            this.mCameraControlInternal = new Camera2CameraControlImpl(cameraCharacteristicsCompat, this.mScheduledExecutorService, this.mExecutor, new ControlUpdateListenerInternal(), cameraInfoImpl.getCameraQuirks());
            this.mCameraInfoInternal = cameraInfoImpl;
            this.mCameraInfoInternal.linkWithCameraControl(this.mCameraControlInternal);
            this.mCameraInfoInternal.setCameraStateSource(this.mCameraStateMachine.getStateLiveData());
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
        this.mCaptureSessionOpenerBuilder = new SynchronizedCaptureSessionOpener.Builder(this.mExecutor, this.mScheduledExecutorService, schedulerHandler, this.mCaptureSessionRepository, cameraInfoImpl.getCameraQuirks(), DeviceQuirks.getAll());
        this.mCameraAvailability = new CameraAvailability(cameraId);
        this.mCameraStateRegistry.registerCamera((Camera)this, this.mExecutor, (CameraStateRegistry.OnOpenAvailableListener)this.mCameraAvailability);
        this.mCameraManager.registerAvailabilityCallback(this.mExecutor, this.mCameraAvailability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private CaptureSessionInterface newCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionProcessor == null) {
                return new CaptureSession();
            }
            return new ProcessingCaptureSession(this.mSessionProcessor, this.mCameraInfoInternal, this.mExecutor, this.mScheduledExecutorService);
        }
    }

    public void open() {
        this.mExecutor.execute(this::openInternal);
    }

    private void openInternal() {
        switch (this.mState) {
            case INITIALIZED: 
            case PENDING_OPEN: {
                this.tryForceOpenCameraDevice(false);
                break;
            }
            case CLOSING: {
                this.setState(InternalState.REOPENING);
                if (this.isSessionCloseComplete() || this.mCameraDeviceError != 0) break;
                Preconditions.checkState((this.mCameraDevice != null ? 1 : 0) != 0, (String)"Camera Device should be open if session close is not complete");
                this.setState(InternalState.OPENED);
                this.openCaptureSession();
                break;
            }
            default: {
                this.debugLog("open() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
    }

    public void close() {
        this.mExecutor.execute(this::closeInternal);
    }

    private void closeInternal() {
        this.debugLog("Closing camera.");
        switch (this.mState) {
            case OPENED: {
                this.setState(InternalState.CLOSING);
                this.closeCamera(false);
                break;
            }
            case OPENING: 
            case REOPENING: {
                boolean canFinish = this.mStateCallback.cancelScheduledReopen();
                this.setState(InternalState.CLOSING);
                if (!canFinish) break;
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.INITIALIZED);
                break;
            }
            default: {
                this.debugLog("close() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
    }

    private void configAndClose(boolean abortInFlightCaptures) {
        CaptureSession noOpSession = new CaptureSession();
        this.mConfiguringForClose.add(noOpSession);
        this.resetCaptureSession(abortInFlightCaptures);
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(640, 480);
        Surface surface = new Surface(surfaceTexture);
        Runnable closeAndCleanupRunner = () -> {
            surface.release();
            surfaceTexture.release();
        };
        SessionConfig.Builder builder = new SessionConfig.Builder();
        ImmediateSurface deferrableSurface = new ImmediateSurface(surface);
        builder.addNonRepeatingSurface((DeferrableSurface)deferrableSurface);
        builder.setTemplateType(1);
        this.debugLog("Start configAndClose.");
        ListenableFuture<Void> openNoOpCaptureSession = noOpSession.open(builder.build(), (CameraDevice)Preconditions.checkNotNull((Object)this.mCameraDevice), this.mCaptureSessionOpenerBuilder.build());
        openNoOpCaptureSession.addListener(() -> this.lambda$configAndClose$1(noOpSession, (DeferrableSurface)deferrableSurface, closeAndCleanupRunner), this.mExecutor);
    }

    void releaseNoOpSession(@NonNull CaptureSession noOpSession, @NonNull DeferrableSurface deferrableSurface, @NonNull Runnable closeAndCleanupRunner) {
        this.mConfiguringForClose.remove(noOpSession);
        ListenableFuture<Void> releaseFuture = this.releaseSession(noOpSession, false);
        deferrableSurface.close();
        Futures.successfulAsList(Arrays.asList(releaseFuture, deferrableSurface.getTerminationFuture())).addListener(closeAndCleanupRunner, CameraXExecutors.directExecutor());
    }

    boolean isSessionCloseComplete() {
        return this.mReleasedCaptureSessions.isEmpty() && this.mConfiguringForClose.isEmpty();
    }

    void finishClose() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        this.mCameraDevice = null;
        if (this.mState == InternalState.CLOSING) {
            this.setState(InternalState.INITIALIZED);
        } else {
            this.mCameraManager.unregisterAvailabilityCallback(this.mCameraAvailability);
            this.setState(InternalState.RELEASED);
            if (this.mUserReleaseNotifier != null) {
                this.mUserReleaseNotifier.set(null);
                this.mUserReleaseNotifier = null;
            }
        }
    }

    void closeCamera(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mState == InternalState.CLOSING || this.mState == InternalState.RELEASING || this.mState == InternalState.REOPENING && this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)("closeCamera should only be called in a CLOSING, RELEASING or REOPENING (with error) state. Current state: " + (Object)((Object)this.mState) + " (error: " + Camera2CameraImpl.getErrorMessage(this.mCameraDeviceError) + ")"));
        if (Build.VERSION.SDK_INT > 23 && Build.VERSION.SDK_INT < 29 && this.isLegacyDevice() && this.mCameraDeviceError == 0) {
            this.configAndClose(abortInFlightCaptures);
        } else {
            this.resetCaptureSession(abortInFlightCaptures);
        }
        this.mCaptureSession.cancelIssuedCaptureRequests();
    }

    @NonNull
    public ListenableFuture<Void> release() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> Futures.propagate(this.releaseInternal(), (CallbackToFutureAdapter.Completer)completer));
            return "Release[request=" + this.mReleaseRequestCount.getAndIncrement() + "]";
        });
    }

    private ListenableFuture<Void> releaseInternal() {
        ListenableFuture<Void> future = this.getOrCreateUserReleaseFuture();
        switch (this.mState) {
            case INITIALIZED: 
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.RELEASING);
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            case OPENED: {
                this.setState(InternalState.RELEASING);
                this.closeCamera(false);
                break;
            }
            case CLOSING: 
            case OPENING: 
            case REOPENING: 
            case RELEASING: {
                boolean canFinish = this.mStateCallback.cancelScheduledReopen();
                this.setState(InternalState.RELEASING);
                if (!canFinish) break;
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            default: {
                this.debugLog("release() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
        return future;
    }

    private ListenableFuture<Void> getOrCreateUserReleaseFuture() {
        if (this.mUserReleaseFuture == null) {
            this.mUserReleaseFuture = this.mState != InternalState.RELEASED ? CallbackToFutureAdapter.getFuture(completer -> {
                Preconditions.checkState((this.mUserReleaseNotifier == null ? 1 : 0) != 0, (String)"Camera can only be released once, so release completer should be null on creation.");
                this.mUserReleaseNotifier = completer;
                return "Release[camera=" + this + "]";
            }) : Futures.immediateFuture(null);
        }
        return this.mUserReleaseFuture;
    }

    ListenableFuture<Void> releaseSession(final @NonNull CaptureSessionInterface captureSession, boolean abortInFlightCaptures) {
        captureSession.close();
        ListenableFuture<Void> releaseFuture = captureSession.release(abortInFlightCaptures);
        this.debugLog("Releasing session in state " + this.mState.name());
        this.mReleasedCaptureSessions.put(captureSession, releaseFuture);
        Futures.addCallback(releaseFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.mReleasedCaptureSessions.remove(captureSession);
                switch (Camera2CameraImpl.this.mState) {
                    case REOPENING: {
                        if (Camera2CameraImpl.this.mCameraDeviceError == 0) break;
                    }
                    case CLOSING: 
                    case RELEASING: {
                        if (!Camera2CameraImpl.this.isSessionCloseComplete() || Camera2CameraImpl.this.mCameraDevice == null) break;
                        ApiCompat.Api21Impl.close(Camera2CameraImpl.this.mCameraDevice);
                        Camera2CameraImpl.this.mCameraDevice = null;
                        break;
                    }
                }
            }

            public void onFailure(@NonNull Throwable t) {
            }
        }, (Executor)CameraXExecutors.directExecutor());
        return releaseFuture;
    }

    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mObservableState;
    }

    public void onUseCaseActive(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        SessionConfig sessionConfig = useCase.getSessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " ACTIVE");
            this.mUseCaseAttachState.setUseCaseActive(useCaseId, sessionConfig, useCaseConfig);
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " INACTIVE");
            this.mUseCaseAttachState.setUseCaseInactive(useCaseId);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        SessionConfig sessionConfig = useCase.getSessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " UPDATED");
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseReset(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        SessionConfig sessionConfig = useCase.getSessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " RESET");
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig);
            this.resetCaptureSession(false);
            this.updateCaptureSessionConfig();
            if (this.mState == InternalState.OPENED) {
                this.openCaptureSession();
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    boolean isUseCaseAttached(@NonNull UseCase useCase) {
        try {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            return (Boolean)CallbackToFutureAdapter.getFuture(completer -> {
                try {
                    this.mExecutor.execute(() -> completer.set((Object)this.mUseCaseAttachState.isUseCaseAttached(useCaseId)));
                }
                catch (RejectedExecutionException e) {
                    completer.setException((Throwable)new RuntimeException("Unable to check if use case is attached. Camera executor shut down."));
                }
                return "isUseCaseAttached";
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to check if use case is attached.", e);
        }
    }

    public void attachUseCases(@NonNull Collection<UseCase> inputUseCases) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(inputUseCases);
        if (useCases.isEmpty()) {
            return;
        }
        this.mCameraControlInternal.incrementUseCount();
        this.notifyStateAttachedToUseCases(new ArrayList<UseCase>(useCases));
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>(this.toUseCaseInfos(useCases));
        try {
            this.mExecutor.execute(() -> {
                try {
                    this.tryAttachUseCases(useCaseInfos);
                }
                finally {
                    this.mCameraControlInternal.decrementUseCount();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.debugLog("Unable to attach use cases.", e);
            this.mCameraControlInternal.decrementUseCount();
        }
    }

    private void tryAttachUseCases(@NonNull Collection<UseCaseInfo> useCaseInfos) {
        boolean attachUseCaseFromEmpty = this.mUseCaseAttachState.getAttachedSessionConfigs().isEmpty();
        ArrayList<String> useCaseIdsToAttach = new ArrayList<String>();
        Rational previewAspectRatio = null;
        for (UseCaseInfo useCaseInfo : useCaseInfos) {
            Size resolution;
            if (this.mUseCaseAttachState.isUseCaseAttached(useCaseInfo.getUseCaseId())) continue;
            this.mUseCaseAttachState.setUseCaseAttached(useCaseInfo.getUseCaseId(), useCaseInfo.getSessionConfig(), useCaseInfo.getUseCaseConfig());
            useCaseIdsToAttach.add(useCaseInfo.getUseCaseId());
            if (useCaseInfo.getUseCaseType() != Preview.class || (resolution = useCaseInfo.getSurfaceResolution()) == null) continue;
            previewAspectRatio = new Rational(resolution.getWidth(), resolution.getHeight());
        }
        if (useCaseIdsToAttach.isEmpty()) {
            return;
        }
        this.debugLog("Use cases [" + TextUtils.join((CharSequence)", ", useCaseIdsToAttach) + "] now ATTACHED");
        if (attachUseCaseFromEmpty) {
            this.mCameraControlInternal.setActive(true);
            this.mCameraControlInternal.incrementUseCount();
        }
        this.addOrRemoveMeteringRepeatingUseCase();
        this.updateZslDisabledByUseCaseConfigStatus();
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        } else {
            this.openInternal();
        }
        if (previewAspectRatio != null) {
            this.mCameraControlInternal.setPreviewAspectRatio(previewAspectRatio);
        }
    }

    @NonNull
    private Collection<UseCaseInfo> toUseCaseInfos(@NonNull Collection<UseCase> useCases) {
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>();
        for (UseCase useCase : useCases) {
            useCaseInfos.add(UseCaseInfo.from(useCase));
        }
        return useCaseInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
        if (cameraConfig == null) {
            cameraConfig = CameraConfigs.emptyConfig();
        }
        SessionProcessor sessionProcessor = cameraConfig.getSessionProcessor(null);
        this.mCameraConfig = cameraConfig;
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionProcessor = sessionProcessor;
        }
    }

    @NonNull
    public CameraConfig getExtendedConfig() {
        return this.mCameraConfig;
    }

    private void notifyStateAttachedToUseCases(List<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            if (this.mNotifyStateAttachedSet.contains(useCaseId)) continue;
            this.mNotifyStateAttachedSet.add(useCaseId);
            useCase.onStateAttached();
        }
    }

    private void notifyStateDetachedToUseCases(List<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            if (!this.mNotifyStateAttachedSet.contains(useCaseId)) continue;
            useCase.onStateDetached();
            this.mNotifyStateAttachedSet.remove(useCaseId);
        }
    }

    public void detachUseCases(@NonNull Collection<UseCase> inputUseCases) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(inputUseCases);
        if (useCases.isEmpty()) {
            return;
        }
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>(this.toUseCaseInfos(useCases));
        this.notifyStateDetachedToUseCases(new ArrayList<UseCase>(useCases));
        this.mExecutor.execute(() -> this.tryDetachUseCases(useCaseInfos));
    }

    private void tryDetachUseCases(@NonNull Collection<UseCaseInfo> useCaseInfos) {
        ArrayList<String> useCaseIdsToDetach = new ArrayList<String>();
        boolean clearPreviewAspectRatio = false;
        for (UseCaseInfo useCaseInfo : useCaseInfos) {
            if (!this.mUseCaseAttachState.isUseCaseAttached(useCaseInfo.getUseCaseId())) continue;
            this.mUseCaseAttachState.removeUseCase(useCaseInfo.getUseCaseId());
            useCaseIdsToDetach.add(useCaseInfo.getUseCaseId());
            if (useCaseInfo.getUseCaseType() != Preview.class) continue;
            clearPreviewAspectRatio = true;
        }
        if (useCaseIdsToDetach.isEmpty()) {
            return;
        }
        this.debugLog("Use cases [" + TextUtils.join((CharSequence)", ", useCaseIdsToDetach) + "] now DETACHED for camera");
        if (clearPreviewAspectRatio) {
            this.mCameraControlInternal.setPreviewAspectRatio(null);
        }
        this.addOrRemoveMeteringRepeatingUseCase();
        if (this.mUseCaseAttachState.getAttachedUseCaseConfigs().isEmpty()) {
            this.mCameraControlInternal.setZslDisabledByUserCaseConfig(false);
        } else {
            this.updateZslDisabledByUseCaseConfigStatus();
        }
        boolean allUseCasesDetached = this.mUseCaseAttachState.getAttachedSessionConfigs().isEmpty();
        if (allUseCasesDetached) {
            this.mCameraControlInternal.decrementUseCount();
            this.resetCaptureSession(false);
            this.mCameraControlInternal.setActive(false);
            this.mCaptureSession = this.newCaptureSession();
            this.closeInternal();
        } else {
            this.updateCaptureSessionConfig();
            this.resetCaptureSession(false);
            if (this.mState == InternalState.OPENED) {
                this.openCaptureSession();
            }
        }
    }

    private void updateZslDisabledByUseCaseConfigStatus() {
        boolean isZslDisabledByUseCaseConfig = false;
        for (UseCaseConfig useCaseConfig : this.mUseCaseAttachState.getAttachedUseCaseConfigs()) {
            isZslDisabledByUseCaseConfig |= useCaseConfig.isZslDisabled(false);
        }
        this.mCameraControlInternal.setZslDisabledByUserCaseConfig(isZslDisabledByUseCaseConfig);
    }

    private void addOrRemoveMeteringRepeatingUseCase() {
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getAttachedBuilder();
        SessionConfig sessionConfig = validatingBuilder.build();
        CaptureConfig captureConfig = sessionConfig.getRepeatingCaptureConfig();
        int sizeRepeatingSurfaces = captureConfig.getSurfaces().size();
        int sizeSessionSurfaces = sessionConfig.getSurfaces().size();
        if (!sessionConfig.getSurfaces().isEmpty()) {
            if (captureConfig.getSurfaces().isEmpty()) {
                if (this.mMeteringRepeatingSession == null) {
                    this.mMeteringRepeatingSession = new MeteringRepeatingSession(this.mCameraInfoInternal.getCameraCharacteristicsCompat(), this.mDisplayInfoManager);
                }
                this.addMeteringRepeating();
            } else if (sizeSessionSurfaces == 1 && sizeRepeatingSurfaces == 1) {
                this.removeMeteringRepeating();
            } else if (sizeRepeatingSurfaces >= 2) {
                this.removeMeteringRepeating();
            } else {
                Logger.d((String)TAG, (String)("mMeteringRepeating is ATTACHED, SessionConfig Surfaces: " + sizeSessionSurfaces + ", CaptureConfig Surfaces: " + sizeRepeatingSurfaces));
            }
        }
    }

    private void removeMeteringRepeating() {
        if (this.mMeteringRepeatingSession != null) {
            this.mUseCaseAttachState.setUseCaseDetached(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode());
            this.mUseCaseAttachState.setUseCaseInactive(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode());
            this.mMeteringRepeatingSession.clear();
            this.mMeteringRepeatingSession = null;
        }
    }

    private void addMeteringRepeating() {
        if (this.mMeteringRepeatingSession != null) {
            this.mUseCaseAttachState.setUseCaseAttached(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode(), this.mMeteringRepeatingSession.getSessionConfig(), this.mMeteringRepeatingSession.getUseCaseConfig());
            this.mUseCaseAttachState.setUseCaseActive(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode(), this.mMeteringRepeatingSession.getSessionConfig(), this.mMeteringRepeatingSession.getUseCaseConfig());
        }
    }

    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mCameraInfoInternal;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public CameraAvailability getCameraAvailability() {
        return this.mCameraAvailability;
    }

    void tryForceOpenCameraDevice(boolean fromScheduledCameraReopen) {
        this.debugLog("Attempting to force open the camera.");
        boolean shouldTryOpenCamera = this.mCameraStateRegistry.tryOpenCamera((Camera)this);
        if (!shouldTryOpenCamera) {
            this.debugLog("No cameras available. Waiting for available camera before opening camera.");
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.openCameraDevice(fromScheduledCameraReopen);
    }

    void tryOpenCameraDevice(boolean fromScheduledCameraReopen) {
        boolean shouldTryOpenCamera;
        this.debugLog("Attempting to open the camera.");
        boolean bl = shouldTryOpenCamera = this.mCameraAvailability.isCameraAvailable() && this.mCameraStateRegistry.tryOpenCamera((Camera)this);
        if (!shouldTryOpenCamera) {
            this.debugLog("No cameras available. Waiting for available camera before opening camera.");
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.openCameraDevice(fromScheduledCameraReopen);
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mExecutor.execute(() -> {
            this.mIsActiveResumingMode = enabled;
            if (enabled && this.mState == InternalState.PENDING_OPEN) {
                this.tryForceOpenCameraDevice(false);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void openCameraDevice(boolean fromScheduledCameraReopen) {
        if (!fromScheduledCameraReopen) {
            this.mStateCallback.resetReopenMonitor();
        }
        this.mStateCallback.cancelScheduledReopen();
        this.debugLog("Opening camera.");
        this.setState(InternalState.OPENING);
        try {
            this.mCameraManager.openCamera(this.mCameraInfoInternal.getCameraId(), this.mExecutor, this.createDeviceStateCallback());
        }
        catch (CameraAccessExceptionCompat e) {
            this.debugLog("Unable to open camera due to " + e.getMessage());
            switch (e.getReason()) {
                case 10001: {
                    this.setState(InternalState.INITIALIZED, CameraState.StateError.create((int)7, (Throwable)e));
                    break;
                }
            }
        }
        catch (SecurityException e) {
            this.debugLog("Unable to open camera due to " + e.getMessage());
            this.setState(InternalState.REOPENING);
            this.mStateCallback.scheduleCameraReopen();
        }
    }

    void updateCaptureSessionConfig() {
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getActiveAndAttachedBuilder();
        if (validatingBuilder.isValid()) {
            SessionConfig useCaseSessionConfig = validatingBuilder.build();
            this.mCameraControlInternal.setTemplate(useCaseSessionConfig.getTemplateType());
            validatingBuilder.add(this.mCameraControlInternal.getSessionConfig());
            SessionConfig sessionConfig = validatingBuilder.build();
            this.mCaptureSession.setSessionConfig(sessionConfig);
        } else {
            this.mCameraControlInternal.resetTemplate();
            this.mCaptureSession.setSessionConfig(this.mCameraControlInternal.getSessionConfig());
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    void openCaptureSession() {
        Preconditions.checkState((this.mState == InternalState.OPENED ? 1 : 0) != 0);
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getAttachedBuilder();
        if (!validatingBuilder.isValid()) {
            this.debugLog("Unable to create capture session due to conflicting configurations");
            return;
        }
        if (!validatingBuilder.build().getImplementationOptions().containsOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION)) {
            validatingBuilder.addImplementationOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION, (Object)StreamUseCaseUtil.getStreamUseCaseFromUseCaseConfigs(this.mUseCaseAttachState.getAttachedUseCaseConfigs(), this.mUseCaseAttachState.getAttachedSessionConfigs()));
        }
        CaptureSessionInterface captureSession = this.mCaptureSession;
        ListenableFuture<Void> openCaptureSession = captureSession.open(validatingBuilder.build(), (CameraDevice)Preconditions.checkNotNull((Object)this.mCameraDevice), this.mCaptureSessionOpenerBuilder.build());
        Futures.addCallback(openCaptureSession, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
            }

            public void onFailure(@NonNull Throwable t) {
                if (t instanceof DeferrableSurface.SurfaceClosedException) {
                    SessionConfig sessionConfig = Camera2CameraImpl.this.findSessionConfigForSurface(((DeferrableSurface.SurfaceClosedException)t).getDeferrableSurface());
                    if (sessionConfig != null) {
                        Camera2CameraImpl.this.postSurfaceClosedError(sessionConfig);
                    }
                    return;
                }
                if (t instanceof CancellationException) {
                    Camera2CameraImpl.this.debugLog("Unable to configure camera cancelled");
                    return;
                }
                if (Camera2CameraImpl.this.mState == InternalState.OPENED) {
                    Camera2CameraImpl.this.setState(InternalState.OPENED, CameraState.StateError.create((int)4, (Throwable)t));
                }
                if (t instanceof CameraAccessException) {
                    Camera2CameraImpl.this.debugLog("Unable to configure camera due to " + t.getMessage());
                } else if (t instanceof TimeoutException) {
                    Logger.e((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this.mCameraInfoInternal.getCameraId() + ", timeout!"));
                }
            }
        }, (Executor)this.mExecutor);
    }

    private boolean isLegacyDevice() {
        Camera2CameraInfoImpl camera2CameraInfo = (Camera2CameraInfoImpl)this.getCameraInfoInternal();
        return camera2CameraInfo.getSupportedHardwareLevel() == 2;
    }

    @Nullable
    SessionConfig findSessionConfigForSurface(@NonNull DeferrableSurface surface) {
        for (SessionConfig sessionConfig : this.mUseCaseAttachState.getAttachedSessionConfigs()) {
            if (!sessionConfig.getSurfaces().contains(surface)) continue;
            return sessionConfig;
        }
        return null;
    }

    void postSurfaceClosedError(@NonNull SessionConfig sessionConfig) {
        ScheduledExecutorService executor = CameraXExecutors.mainThreadExecutor();
        List errorListeners = sessionConfig.getErrorListeners();
        if (!errorListeners.isEmpty()) {
            SessionConfig.ErrorListener errorListener = (SessionConfig.ErrorListener)errorListeners.get(0);
            this.debugLog("Posting surface closed", new Throwable());
            executor.execute(() -> errorListener.onError(sessionConfig, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET));
        }
    }

    void resetCaptureSession(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mCaptureSession != null ? 1 : 0) != 0);
        this.debugLog("Resetting Capture Session");
        CaptureSessionInterface oldCaptureSession = this.mCaptureSession;
        SessionConfig previousSessionConfig = oldCaptureSession.getSessionConfig();
        List<CaptureConfig> unissuedCaptureConfigs = oldCaptureSession.getCaptureConfigs();
        this.mCaptureSession = this.newCaptureSession();
        this.mCaptureSession.setSessionConfig(previousSessionConfig);
        this.mCaptureSession.issueCaptureRequests(unissuedCaptureConfigs);
        this.releaseSession(oldCaptureSession, abortInFlightCaptures);
    }

    private CameraDevice.StateCallback createDeviceStateCallback() {
        SessionConfig config = this.mUseCaseAttachState.getAttachedBuilder().build();
        List configuredStateCallbacks = config.getDeviceStateCallbacks();
        ArrayList<CameraDevice.StateCallback> allStateCallbacks = new ArrayList<CameraDevice.StateCallback>(configuredStateCallbacks);
        allStateCallbacks.add(this.mCaptureSessionRepository.getCameraStateCallback());
        allStateCallbacks.add(this.mStateCallback);
        return CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks);
    }

    private boolean checkAndAttachRepeatingSurface(CaptureConfig.Builder captureConfigBuilder) {
        if (!captureConfigBuilder.getSurfaces().isEmpty()) {
            Logger.w((String)TAG, (String)"The capture config builder already has surface inside.");
            return false;
        }
        for (SessionConfig sessionConfig : this.mUseCaseAttachState.getActiveAndAttachedSessionConfigs()) {
            List surfaces = sessionConfig.getRepeatingCaptureConfig().getSurfaces();
            if (surfaces.isEmpty()) continue;
            for (DeferrableSurface surface : surfaces) {
                captureConfigBuilder.addSurface(surface);
            }
        }
        if (captureConfigBuilder.getSurfaces().isEmpty()) {
            Logger.w((String)TAG, (String)"Unable to find a repeating surface to attach to CaptureConfig");
            return false;
        }
        return true;
    }

    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mCameraControlInternal;
    }

    void submitCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        ArrayList<CaptureConfig> captureConfigsWithSurface = new ArrayList<CaptureConfig>();
        for (CaptureConfig captureConfig : captureConfigs) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            if (captureConfig.getTemplateType() == 5 && captureConfig.getCameraCaptureResult() != null) {
                builder.setCameraCaptureResult(captureConfig.getCameraCaptureResult());
            }
            if (captureConfig.getSurfaces().isEmpty() && captureConfig.isUseRepeatingSurface() && !this.checkAndAttachRepeatingSurface(builder)) continue;
            captureConfigsWithSurface.add(builder.build());
        }
        this.debugLog("Issue capture request");
        this.mCaptureSession.issueCaptureRequests(captureConfigsWithSurface);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "Camera@%x[id=%s]", this.hashCode(), this.mCameraInfoInternal.getCameraId());
    }

    @NonNull
    static String getUseCaseId(@NonNull UseCase useCase) {
        return useCase.getName() + useCase.hashCode();
    }

    void debugLog(@NonNull String msg) {
        this.debugLog(msg, null);
    }

    private void debugLog(@NonNull String msg, @Nullable Throwable throwable) {
        String msgString = String.format("{%s} %s", this.toString(), msg);
        Logger.d((String)TAG, (String)msgString, (Throwable)throwable);
    }

    void setState(@NonNull InternalState state) {
        this.setState(state, null);
    }

    void setState(@NonNull InternalState state, @Nullable CameraState.StateError stateError) {
        this.setState(state, stateError, true);
    }

    void setState(@NonNull InternalState state, @Nullable CameraState.StateError stateError, boolean notifyImmediately) {
        CameraInternal.State publicState;
        this.debugLog("Transitioning camera internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state));
        this.mState = state;
        switch (state) {
            case INITIALIZED: {
                publicState = CameraInternal.State.CLOSED;
                break;
            }
            case PENDING_OPEN: {
                publicState = CameraInternal.State.PENDING_OPEN;
                break;
            }
            case OPENING: 
            case REOPENING: {
                publicState = CameraInternal.State.OPENING;
                break;
            }
            case OPENED: {
                publicState = CameraInternal.State.OPEN;
                break;
            }
            case CLOSING: {
                publicState = CameraInternal.State.CLOSING;
                break;
            }
            case RELEASING: {
                publicState = CameraInternal.State.RELEASING;
                break;
            }
            case RELEASED: {
                publicState = CameraInternal.State.RELEASED;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
            }
        }
        this.mCameraStateRegistry.markCameraState((Camera)this, publicState, notifyImmediately);
        this.mObservableState.postValue((Object)publicState);
        this.mCameraStateMachine.updateState(publicState, stateError);
    }

    static String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "ERROR_NONE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return "UNKNOWN ERROR";
    }

    private /* synthetic */ void lambda$configAndClose$1(CaptureSession noOpSession, DeferrableSurface deferrableSurface, Runnable closeAndCleanupRunner) {
        this.releaseNoOpSession(noOpSession, deferrableSurface, closeAndCleanupRunner);
    }

    final class ControlUpdateListenerInternal
    implements CameraControlInternal.ControlUpdateCallback {
        ControlUpdateListenerInternal() {
        }

        public void onCameraControlUpdateSessionConfig() {
            Camera2CameraImpl.this.updateCaptureSessionConfig();
        }

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            Camera2CameraImpl.this.submitCaptureRequests((List)Preconditions.checkNotNull(captureConfigs));
        }
    }

    final class CameraAvailability
    extends CameraManager.AvailabilityCallback
    implements CameraStateRegistry.OnOpenAvailableListener {
        private final String mCameraId;
        private boolean mCameraAvailable = true;

        CameraAvailability(String cameraId) {
            this.mCameraId = cameraId;
        }

        public void onCameraAvailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = true;
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.tryOpenCameraDevice(false);
            }
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = false;
        }

        public void onOpenAvailable() {
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.tryOpenCameraDevice(false);
            }
        }

        boolean isCameraAvailable() {
            return this.mCameraAvailable;
        }
    }

    @RequiresApi(value=21)
    final class StateCallback
    extends CameraDevice.StateCallback {
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private ScheduledReopen mScheduledReopenRunnable;
        ScheduledFuture<?> mScheduledReopenHandle;
        @NonNull
        private final CameraReopenMonitor mCameraReopenMonitor = new CameraReopenMonitor();

        StateCallback(@NonNull Executor executor, ScheduledExecutorService scheduler) {
            this.mExecutor = executor;
            this.mScheduler = scheduler;
        }

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onOpened()");
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = 0;
            this.resetReopenMonitor();
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.mCameraDevice.close();
                    Camera2CameraImpl.this.mCameraDevice = null;
                    break;
                }
                case OPENING: 
                case REOPENING: {
                    Camera2CameraImpl.this.setState(InternalState.OPENED);
                    Camera2CameraImpl.this.openCaptureSession();
                    break;
                }
                default: {
                    throw new IllegalStateException("onOpened() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onClosed(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onClosed()");
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDevice == null ? 1 : 0) != 0, (String)("Unexpected onClose callback on camera device: " + cameraDevice));
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.finishClose();
                    break;
                }
                case REOPENING: {
                    if (Camera2CameraImpl.this.mCameraDeviceError != 0) {
                        Camera2CameraImpl.this.debugLog("Camera closed due to error: " + Camera2CameraImpl.getErrorMessage(Camera2CameraImpl.this.mCameraDeviceError));
                        this.scheduleCameraReopen();
                        break;
                    }
                    Camera2CameraImpl.this.tryOpenCameraDevice(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("Camera closed while in state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onDisconnected()");
            this.onError(cameraDevice, 1);
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = error;
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Logger.e((String)Camera2CameraImpl.TAG, (String)String.format("CameraDevice.onError(): %s failed with %s while in %s state. Will finish closing camera.", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error), Camera2CameraImpl.this.mState.name()));
                    Camera2CameraImpl.this.closeCamera(false);
                    break;
                }
                case OPENED: 
                case OPENING: 
                case REOPENING: {
                    Logger.d((String)Camera2CameraImpl.TAG, (String)String.format("CameraDevice.onError(): %s failed with %s while in %s state. Will attempt recovering from error.", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error), Camera2CameraImpl.this.mState.name()));
                    this.handleErrorOnOpen(cameraDevice, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("onError() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        private void handleErrorOnOpen(@NonNull CameraDevice cameraDevice, int error) {
            Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.OPENING || Camera2CameraImpl.this.mState == InternalState.OPENED || Camera2CameraImpl.this.mState == InternalState.REOPENING ? 1 : 0) != 0, (String)("Attempt to handle open error from non open state: " + (Object)((Object)Camera2CameraImpl.this.mState)));
            switch (error) {
                case 1: 
                case 2: 
                case 4: {
                    Logger.d((String)Camera2CameraImpl.TAG, (String)String.format("Attempt to reopen camera[%s] after error[%s]", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error)));
                    this.reopenCameraAfterError(error);
                    break;
                }
                default: {
                    Logger.e((String)Camera2CameraImpl.TAG, (String)("Error observed on open (or opening) camera device " + cameraDevice.getId() + ": " + Camera2CameraImpl.getErrorMessage(error) + " closing camera."));
                    int publicErrorCode = error == 3 ? 5 : 6;
                    Camera2CameraImpl.this.setState(InternalState.CLOSING, CameraState.StateError.create((int)publicErrorCode));
                    Camera2CameraImpl.this.closeCamera(false);
                }
            }
        }

        private void reopenCameraAfterError(int error) {
            int publicErrorCode;
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)"Can only reopen camera device after error if the camera device is actually in an error state.");
            switch (error) {
                case 1: {
                    publicErrorCode = 2;
                    break;
                }
                case 2: {
                    publicErrorCode = 1;
                    break;
                }
                default: {
                    publicErrorCode = 3;
                }
            }
            Camera2CameraImpl.this.setState(InternalState.REOPENING, CameraState.StateError.create((int)publicErrorCode));
            Camera2CameraImpl.this.closeCamera(false);
        }

        void scheduleCameraReopen() {
            Preconditions.checkState((this.mScheduledReopenRunnable == null ? 1 : 0) != 0);
            Preconditions.checkState((this.mScheduledReopenHandle == null ? 1 : 0) != 0);
            if (this.mCameraReopenMonitor.canScheduleCameraReopen()) {
                this.mScheduledReopenRunnable = new ScheduledReopen(this.mExecutor);
                Camera2CameraImpl.this.debugLog("Attempting camera re-open in " + this.mCameraReopenMonitor.getReopenDelayMs() + "ms: " + this.mScheduledReopenRunnable + " activeResuming = " + Camera2CameraImpl.this.mIsActiveResumingMode);
                this.mScheduledReopenHandle = this.mScheduler.schedule(this.mScheduledReopenRunnable, (long)this.mCameraReopenMonitor.getReopenDelayMs(), TimeUnit.MILLISECONDS);
            } else {
                Logger.e((String)Camera2CameraImpl.TAG, (String)("Camera reopening attempted for " + this.mCameraReopenMonitor.getReopenLimitMs() + "ms without success."));
                Camera2CameraImpl.this.setState(InternalState.PENDING_OPEN, null, false);
            }
        }

        boolean cancelScheduledReopen() {
            boolean cancelled = false;
            if (this.mScheduledReopenHandle != null) {
                Camera2CameraImpl.this.debugLog("Cancelling scheduled re-open: " + this.mScheduledReopenRunnable);
                this.mScheduledReopenRunnable.cancel();
                this.mScheduledReopenRunnable = null;
                this.mScheduledReopenHandle.cancel(false);
                this.mScheduledReopenHandle = null;
                cancelled = true;
            }
            return cancelled;
        }

        void resetReopenMonitor() {
            this.mCameraReopenMonitor.reset();
        }

        boolean shouldActiveResume() {
            return Camera2CameraImpl.this.mIsActiveResumingMode && (Camera2CameraImpl.this.mCameraDeviceError == 1 || Camera2CameraImpl.this.mCameraDeviceError == 2);
        }

        class CameraReopenMonitor {
            static final int REOPEN_DELAY_MS = 700;
            static final int REOPEN_LIMIT_MS = 10000;
            static final int ACTIVE_REOPEN_DELAY_BASE_MS = 1000;
            static final int ACTIVE_REOPEN_LIMIT_MS = 1800000;
            static final int INVALID_TIME = -1;
            private long mFirstReopenTime = -1L;

            CameraReopenMonitor() {
            }

            int getReopenDelayMs() {
                if (!StateCallback.this.shouldActiveResume()) {
                    return 700;
                }
                long elapsedTime = this.getElapsedTime();
                if (elapsedTime <= 120000L) {
                    return 1000;
                }
                if (elapsedTime <= 300000L) {
                    return 2000;
                }
                return 4000;
            }

            int getReopenLimitMs() {
                if (!StateCallback.this.shouldActiveResume()) {
                    return 10000;
                }
                return 1800000;
            }

            long getElapsedTime() {
                long now = SystemClock.uptimeMillis();
                if (this.mFirstReopenTime == -1L) {
                    this.mFirstReopenTime = now;
                }
                return now - this.mFirstReopenTime;
            }

            boolean canScheduleCameraReopen() {
                boolean hasReachedLimit;
                boolean bl = hasReachedLimit = this.getElapsedTime() >= (long)this.getReopenLimitMs();
                if (hasReachedLimit) {
                    this.reset();
                    return false;
                }
                return true;
            }

            void reset() {
                this.mFirstReopenTime = -1L;
            }
        }

        class ScheduledReopen
        implements Runnable {
            private Executor mExecutor;
            private boolean mCancelled = false;

            ScheduledReopen(Executor executor) {
                this.mExecutor = executor;
            }

            void cancel() {
                this.mCancelled = true;
            }

            @Override
            public void run() {
                this.mExecutor.execute(() -> {
                    if (!this.mCancelled) {
                        Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.REOPENING ? 1 : 0) != 0);
                        if (StateCallback.this.shouldActiveResume()) {
                            Camera2CameraImpl.this.tryForceOpenCameraDevice(true);
                        } else {
                            Camera2CameraImpl.this.tryOpenCameraDevice(true);
                        }
                    }
                });
            }
        }
    }

    @AutoValue
    static abstract class UseCaseInfo {
        UseCaseInfo() {
        }

        @NonNull
        static UseCaseInfo create(@NonNull String useCaseId, @NonNull Class<?> useCaseType, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable Size surfaceResolution) {
            return new AutoValue_Camera2CameraImpl_UseCaseInfo(useCaseId, useCaseType, sessionConfig, useCaseConfig, surfaceResolution);
        }

        @NonNull
        static UseCaseInfo from(@NonNull UseCase useCase) {
            return UseCaseInfo.create(Camera2CameraImpl.getUseCaseId(useCase), useCase.getClass(), useCase.getSessionConfig(), useCase.getCurrentConfig(), useCase.getAttachedSurfaceResolution());
        }

        @NonNull
        abstract String getUseCaseId();

        @NonNull
        abstract Class<?> getUseCaseType();

        @NonNull
        abstract SessionConfig getSessionConfig();

        @NonNull
        abstract UseCaseConfig<?> getUseCaseConfig();

        @Nullable
        abstract Size getSurfaceResolution();
    }

    static enum InternalState {
        INITIALIZED,
        PENDING_OPEN,
        OPENING,
        OPENED,
        CLOSING,
        REOPENING,
        RELEASING,
        RELEASED;

    }
}

