/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.v7.widget.Toolbar;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AbstractAppBarOnDestinationChangedListener;
import androidx.navigation.ui.AppBarConfiguration;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ToolbarOnDestinationChangedListener
extends AbstractAppBarOnDestinationChangedListener {
    private final WeakReference<Toolbar> mToolbarWeakReference;

    ToolbarOnDestinationChangedListener(@NonNull Toolbar toolbar, @NonNull AppBarConfiguration configuration) {
        super(toolbar.getContext(), configuration);
        this.mToolbarWeakReference = new WeakReference<Toolbar>(toolbar);
    }

    @Override
    public void onDestinationChanged(@NonNull NavController controller, @NonNull NavDestination destination, @Nullable Bundle arguments) {
        Toolbar toolbar = (Toolbar)this.mToolbarWeakReference.get();
        if (toolbar == null) {
            controller.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            return;
        }
        super.onDestinationChanged(controller, destination, arguments);
    }

    @Override
    protected void setTitle(CharSequence title) {
        ((Toolbar)this.mToolbarWeakReference.get()).setTitle(title);
    }

    @Override
    protected void setNavigationIcon(Drawable icon, @StringRes int contentDescription) {
        Toolbar toolbar = (Toolbar)this.mToolbarWeakReference.get();
        if (toolbar != null) {
            toolbar.setNavigationIcon(icon);
            toolbar.setNavigationContentDescription(contentDescription);
        }
    }
}

