/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.api;

import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import net.conjur.util.JsonSupport;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Token {
    private static final int DEFAULT_LIFESPAN_SECONDS = 480;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss ZZZ");
    private Fields fields;
    private Payload payload;
    private ProtectedText protectedText;
    private final String json;
    private DateTime timestamp;
    private DateTime expiration;

    private Token(String json) {
        this.json = json;
    }

    private Fields fields() {
        if (this.fields == null) {
            this.fields = JsonSupport.fromJson(this.json, Fields.class);
        }
        return this.fields;
    }

    private Payload payload() {
        if (this.payload == null) {
            this.payload = JsonSupport.fromJson(this.fromBase64(this.fields().payload), Payload.class);
        }
        return this.payload;
    }

    private ProtectedText protectedText() {
        if (this.protectedText == null) {
            this.protectedText = JsonSupport.fromJson(this.fromBase64(this.fields().protectedText), ProtectedText.class);
        }
        return this.protectedText;
    }

    public String getData() {
        return this.payload().data;
    }

    public String getSignature() {
        return this.fields().signature;
    }

    public String getKey() {
        return this.protectedText().key;
    }

    public DateTime getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = new DateTime((Long.parseLong(this.payload().timestamp) - 37L) * 1000L);
        }
        return this.timestamp;
    }

    public DateTime getExpiration() {
        if (this.expiration == null) {
            this.expiration = this.fields().expiration == null ? this.getTimestamp().plusSeconds(480) : DATE_TIME_FORMATTER.parseDateTime(this.fields().expiration);
        }
        return this.expiration;
    }

    public boolean willExpireWithin(int seconds) {
        return DateTime.now().plusSeconds(seconds).isAfter((ReadableInstant)this.getExpiration());
    }

    public boolean isExpired() {
        return this.willExpireWithin(0);
    }

    public String toString() {
        return this.toJson();
    }

    private String toJson() {
        return this.json;
    }

    public static Token fromJson(String json) {
        return new Token(json);
    }

    private String fromBase64(String base64) {
        return new String(Base64.decodeBase64((String)base64), StandardCharsets.UTF_8);
    }

    private String toBase64() {
        return Base64.encodeBase64String((byte[])this.toJson().getBytes());
    }

    public String toHeader() {
        return "Token token=\"" + this.toBase64() + "\"";
    }

    private static class ProtectedText {
        @SerializedName(value="kid")
        public String key;

        private ProtectedText() {
        }
    }

    private static class Payload {
        @SerializedName(value="sub")
        private String data;
        @SerializedName(value="iat")
        private String timestamp;

        private Payload() {
        }
    }

    private static class Fields {
        @SerializedName(value="protected")
        private String protectedText;
        private String payload;
        private String signature;
        private String expiration;

        private Fields() {
        }
    }
}

