#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys


def create_deployment_record(task_reporting_api, task, server, status=None, deploymentTask_url=None, environmentName=None, version=None):
    try:
        record = task_reporting_api.newDeploymentRecord()
        record.targetId = task.id
        record.status = status
        record.serverUrl = server['url']
        record.serverUser = server['username']
        record.deploymentTask_url = deploymentTask_url
        record.deploymentTask = "Bamboo Deployment"
        record.environmentName = environmentName
        record.version = version
        record.applicationName = ""
        task_reporting_api.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.PlanRecord` - {}".format(exctype, value))
        

def create_build_record(task_reporting_api, task, server, project=None, build_url=None, build_id=None, build_status=None, start_date=None, end_date=None, duration=None):
    try:
        record = task_reporting_api.newBuildRecord()
        record.targetId = task.id
        record.serverUrl = server['url']
        record.serverUser = server['username']
        record.build_url = build_url
        record.project = project
        record.build = build_id
        record.outcome = build_status
        record.duration = duration
        record.startDate = start_date
        record.endDate = end_date
        task_reporting_api.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.PlanRecord` - {}".format(exctype, value))