/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.io.IOException;
import java.io.Writer;

public final class XMLQuoter {
    public static void outputXMLText(Writer w, String text) throws IOException {
        int len = text.length();
        if (len < 2) {
            if (len == 1) {
                char c = text.charAt(0);
                switch (c) {
                    case '<': {
                        w.write("&lt;");
                        break;
                    }
                    case '&': {
                        w.write("&amp;");
                        break;
                    }
                    default: {
                        w.write(c);
                    }
                }
            }
            return;
        }
        for (int i = 0; i < len; ++i) {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = text.charAt(i)) != '<' && c != '&' && (c != '>' || i < 2 || text.charAt(i - 1) != ']' || text.charAt(i - 2) != ']')) {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(text, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            w.write("&gt;");
        }
    }

    public static void outputXMLText(Writer w, char[] ch, int offset, int len) throws IOException {
        int i = offset;
        len += offset;
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = ch[i]) != '<' && c != '&' && (c != '>' || i < offset + 2 || ch[i - 1] != ']' || ch[i - 2] != ']')) {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(ch, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            w.write("&gt;");
        } while (++i < len);
    }

    public static void outputDTDText(Writer w, char[] ch, int offset, int len) throws IOException {
        int i = offset;
        len += offset;
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = ch[i]) != '\"' && c != '&' && c != '%') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(ch, start, outLen);
            }
            if (i >= len) continue;
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c == '>') {
                w.write("&#37;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&#34;");
        } while (++i < len);
    }

    public static void outputDoubleQuotedAttr(Writer w, String value) throws IOException {
        int i = 0;
        int len = value.length();
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = value.charAt(i)) != '<' && c != '&' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(value, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&quot;");
        } while (++i < len);
    }

    public static boolean isAllWhitespace(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllWhitespace(char[] ch, int start, int len) {
        len += start;
        while (start < len) {
            if (ch[start] > ' ') {
                return false;
            }
            ++start;
        }
        return true;
    }
}

