/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.stream;

import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.cfg.InputConfigFlags;
import com.ctc.wstx.stax.cfg.ParsingErrorMsgs;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.evt.WEntityDeclInt;
import com.ctc.wstx.stax.evt.WEntityDeclaration;
import com.ctc.wstx.stax.exc.WstxEOFException;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.exc.WstxIOException;
import com.ctc.wstx.stax.exc.WstxParsingException;
import com.ctc.wstx.stax.exc.WstxUnexpectedCharException;
import com.ctc.wstx.stax.io.WstxInputData;
import com.ctc.wstx.stax.io.WstxInputLocation;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.io.WstxInputSource;
import com.ctc.wstx.util.ExceptionUtil;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.TextBuffer;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends WstxInputData
implements InputConfigFlags,
ParsingErrorMsgs {
    public static final char CHAR_CR_LF_OR_NULL = '\r';
    protected static final char CHAR_FIRST_PURE_TEXT = '?';
    protected static final char CHAR_LOWEST_LEGAL_LOCALNAME_CHAR = '-';
    private static final int VALID_CHAR_COUNT = 256;
    private static final byte NAME_CHAR_INVALID_B = 0;
    private static final byte NAME_CHAR_ALL_VALID_B = 1;
    private static final byte NAME_CHAR_VALID_NONFIRST_B = -1;
    private static final int NAME_CHAR_INVALID_I = 0;
    private static final int NAME_CHAR_ALL_VALID_I = 1;
    private static final int NAME_CHAR_VALID_NONFIRST_I = -1;
    private static final byte[] sCharValidity;
    private static final int VALID_PUBID_CHAR_COUNT = 128;
    private static final byte[] sPubidValidity;
    private static final byte PUBID_CHAR_INVALID_B = 0;
    private static final byte PUBID_CHAR_VALID_B = 1;
    protected final ReaderConfig mConfig;
    protected final boolean mCfgNsEnabled;
    final SymbolTable mSymbols;
    protected WstxInputSource mInput;
    protected final WstxInputSource mRootInput;
    WstxInputResolver mEntityResolver = null;
    public char[] mNameBuffer = null;
    protected TextBuffer mTextBuffer;
    static final WEntityDeclInt sEntityLt;
    static final WEntityDeclInt sEntityGt;
    static final WEntityDeclInt sEntityAmp;
    static final WEntityDeclInt sEntityApos;
    static final WEntityDeclInt sEntityQuot;
    protected int mTokenInputTotal = 0;
    protected int mTokenInputRow = 1;
    protected int mTokenInputCol = 1;

    protected StreamScanner(WstxInputSource input, ReaderConfig cfg, WstxInputResolver res) {
        this.mInput = input;
        this.mRootInput = input;
        this.mConfig = cfg;
        this.mSymbols = cfg.getSymbols();
        int cf = cfg.getConfigFlags();
        this.mCfgNsEnabled = (cf & 1) != 0;
        this.mInputBuffer = null;
        this.mInputLen = 0;
        this.mInputPtr = 0;
        this.mEntityResolver = res;
    }

    public Location getLocation() {
        if (this.mInput == null) {
            return new WstxInputLocation(null, "", "", this.mTokenInputTotal, this.mTokenInputCol, this.mTokenInputRow);
        }
        return this.mInput.getLocation(this.mTokenInputTotal, this.mTokenInputRow, this.mTokenInputCol);
    }

    public WstxInputLocation getLastCharLocation() {
        if (this.mInput == null) {
            return new WstxInputLocation(null, "", "", this.mCurrInputProcessed + this.mInputPtr - 1, this.mCurrInputRow, this.mInputPtr - this.mCurrInputRowStart);
        }
        return this.mInput.getLocation(this.mCurrInputProcessed + this.mInputPtr - 1, this.mCurrInputRow, this.mInputPtr - this.mCurrInputRowStart);
    }

    public URL getSource() {
        return this.mInput.getSource();
    }

    public String getSystemId() {
        return this.mInput.getSystemId();
    }

    public void throwParseError(String msg) throws WstxParsingException {
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    public void throwParseError(String format, Object arg) throws WstxParsingException {
        String msg = MessageFormat.format(format, arg);
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    public void throwParseError(String format, Object arg, Object arg2) throws WstxParsingException {
        String msg = MessageFormat.format(format, arg, arg2);
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    protected void throwUnexpectedChar(int i, String msg) throws WstxException {
        char c = (char)i;
        String excMsg = Character.isISOControl(c) ? "Unexpected character (CTRL-CHAR, code " + i + ")" + msg : "Unexpected character '" + c + "' (code " + i + ")" + msg;
        WstxInputLocation loc = this.getLastCharLocation();
        throw new WstxUnexpectedCharException(excMsg, (Location)loc, c);
    }

    protected void throwNullChar() throws WstxException {
        WstxInputLocation loc = this.getLastCharLocation();
        throw new WstxUnexpectedCharException("Illegal character (NULL, unicode 0) encountered: not valid in any context", (Location)loc, '\u0000');
    }

    protected void throwUnexpectedEOF(String msg) throws WstxException {
        throw new WstxEOFException("Unexpected EOF" + (msg == null ? "" : msg + "."), this.getLastCharLocation());
    }

    protected void throwFromIOE(IOException ioe) throws WstxException {
        WstxIOException newEx = new WstxIOException(ioe);
        throw newEx;
    }

    protected void throwFromStrE(XMLStreamException strex) throws WstxException {
        if (strex instanceof WstxException) {
            throw (WstxException)strex;
        }
        WstxException newEx = new WstxException(strex);
        JdkFeatures.getInstance().setInitCause(newEx, strex);
        throw newEx;
    }

    protected void throwLazyError(Exception e) {
        ExceptionUtil.throwRuntimeException(e);
    }

    protected String tokenTypeDesc(int type) {
        return ErrorConsts.tokenTypeDesc(type);
    }

    public final WstxInputSource getCurrentInput() {
        return this.mInput;
    }

    protected final int inputInBuffer() {
        return this.mInputLen - this.mInputPtr;
    }

    protected final int getNext() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen && !this.loadMore()) {
            return -1;
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final char getNextChar(String errorMsg) throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore(errorMsg);
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final char getNextChar(String errorMsg, TextBuffer tb) throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore(errorMsg);
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final int peekNext() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen && !this.loadMore()) {
            return -1;
        }
        return this.mInputBuffer[this.mInputPtr];
    }

    protected final int getNextAfterWS(char c) throws IOException, WstxException {
        do {
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.throwNullChar();
            }
            if (this.mInputPtr < this.mInputLen || this.loadMore()) continue;
            return -1;
        } while ((c = this.mInputBuffer[this.mInputPtr++]) <= ' ');
        return c;
    }

    protected final char getNextCharAfterWS(char c, String errorMsg) throws IOException, WstxException {
        do {
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.throwNullChar();
            }
            if (this.mInputPtr < this.mInputLen || this.loadMore()) continue;
            this.throwUnexpectedEOF(errorMsg);
        } while ((c = this.mInputBuffer[this.mInputPtr++]) <= ' ');
        return c;
    }

    protected final int getNextAfterWS() throws IOException, WstxException {
        char c;
        if (this.mInputPtr >= this.mInputLen && !this.loadMore()) {
            return -1;
        }
        if ((c = this.mInputBuffer[this.mInputPtr++]) <= ' ') {
            return this.getNextAfterWS(c);
        }
        return c;
    }

    protected final char getNextCharAfterWS(String errorMsg) throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore(errorMsg);
        }
        char c = this.mInputBuffer[this.mInputPtr++];
        while (c <= ' ') {
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.throwNullChar();
            }
            if (this.mInputPtr >= this.mInputLen) {
                this.loadMore(errorMsg);
            }
            c = this.mInputBuffer[this.mInputPtr++];
        }
        return c;
    }

    protected final void skipWS() throws IOException, WstxException {
        while (true) {
            if (this.mInputPtr >= this.mInputLen && !this.loadMore()) {
                return;
            }
            char c = this.mInputBuffer[this.mInputPtr];
            if (c > ' ') break;
            ++this.mInputPtr;
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c != '\u0000') continue;
            this.throwNullChar();
        }
    }

    protected final boolean skipCRLF(char c) throws IOException, WstxException {
        boolean result;
        if (c == '\r' && this.peekNext() == 10) {
            ++this.mInputPtr;
            result = true;
        } else {
            result = false;
        }
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
        return result;
    }

    protected final void markLF() {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
    }

    protected final void markLF(int inputPtr) {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = inputPtr;
    }

    protected final void pushback() {
        --this.mInputPtr;
    }

    protected void initInputSource(WstxInputSource newInput, boolean isExt) throws IOException, XMLStreamException {
        this.mInput = newInput;
        this.mInputPtr = 0;
        this.mInputLen = 0;
        this.mInput.initInputLocation(this);
        if (isExt) {
            // empty if block
        }
    }

    protected boolean loadMore() throws IOException, WstxException {
        WstxInputSource input = this.mInput;
        do {
            this.mCurrInputProcessed += this.mInputLen;
            this.mCurrInputRowStart -= this.mInputLen;
            int count = input.readInto(this);
            if (count > 0) {
                return true;
            }
            input.close();
            if (input == this.mRootInput) {
                return false;
            }
            WstxInputSource parent = input.getParent();
            if (parent == null) {
                throw new Error("Internal error: null parent for input source '" + input + "'; should never occur (should have stopped at root input '" + this.mRootInput + "'.");
            }
            this.mInput = input = parent;
            input.restoreContext(this);
        } while (this.mInputPtr >= this.mInputLen);
        return true;
    }

    protected final boolean loadMore(String errorMsg) throws WstxException, IOException {
        if (!this.loadMore()) {
            this.throwUnexpectedEOF(errorMsg);
        }
        return true;
    }

    protected boolean ensureInput(int minAmount) throws IOException {
        int currAmount = this.mInputLen - this.mInputPtr;
        if (currAmount >= minAmount) {
            return true;
        }
        return this.mInput.readMore(this, minAmount);
    }

    protected char resolveSimpleEntity(boolean checkStd) throws WstxException {
        char c;
        char[] buf = this.mInputBuffer;
        int ptr = this.mInputPtr;
        if ((c = buf[ptr++]) == '#') {
            c = buf[ptr++];
            int value = 0;
            int inputLen = this.mInputLen;
            if (c == 'x') {
                while (ptr < inputLen && (c = buf[ptr++]) != ';') {
                    value <<= 4;
                    if (c <= '9' && c >= '0') {
                        value += c - 48;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        value += 10 + (c - 97);
                        continue;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        value += 10 + (c - 65);
                        continue;
                    }
                    this.mInputPtr = ptr;
                    this.throwUnexpectedChar(c, "; expected a hex number (0-9a-zA-Z).");
                }
            } else {
                while (c != ';') {
                    if (c <= '9' && c >= '0') {
                        value = value * 10 + (c - 48);
                    } else {
                        this.mInputPtr = ptr;
                        this.throwUnexpectedChar(c, "; expected a decimal number.");
                    }
                    if (ptr < inputLen) {
                        c = buf[ptr++];
                        continue;
                    }
                    break;
                }
            }
            if (c == ';') {
                if (value == 0) {
                    this.throwParseError("Invalid character reference -- null character not allowed in XML content.");
                }
                this.mInputPtr = ptr;
                return (char)value;
            }
        } else if (checkStd) {
            int len;
            if (c == 'a') {
                int len2;
                if ((c = buf[ptr++]) == 'm') {
                    if (buf[ptr++] == 'p' && ptr < this.mInputLen && buf[ptr++] == ';') {
                        this.mInputPtr = ptr;
                        return '&';
                    }
                } else if (c == 'p' && buf[ptr++] == 'o' && ptr < (len2 = this.mInputLen) && buf[ptr++] == 's' && ptr < len2 && buf[ptr++] == ';') {
                    this.mInputPtr = ptr;
                    return '\'';
                }
            } else if (c == 'g') {
                if (buf[ptr++] == 't' && buf[ptr++] == ';') {
                    this.mInputPtr = ptr;
                    return '>';
                }
            } else if (c == 'l') {
                if (buf[ptr++] == 't' && buf[ptr++] == ';') {
                    this.mInputPtr = ptr;
                    return '<';
                }
            } else if (c == 'q' && buf[ptr++] == 'u' && buf[ptr++] == 'o' && ptr < (len = this.mInputLen) && buf[ptr++] == 't' && ptr < len && buf[ptr++] == ';') {
                this.mInputPtr = ptr;
                return '\"';
            }
        }
        return '\u0000';
    }

    protected char resolveCharOnlyEntity(boolean checkStd) throws IOException, WstxException {
        char c;
        int avail = this.mInputLen - this.mInputPtr;
        if (avail < 6) {
            --this.mInputPtr;
            if (!this.ensureInput(6)) {
                avail = this.inputInBuffer();
                if (avail < 3) {
                    this.throwUnexpectedEOF(" in entity reference");
                }
            } else {
                avail = 6;
            }
            ++this.mInputPtr;
        }
        if ((c = this.mInputBuffer[this.mInputPtr]) == '#') {
            ++this.mInputPtr;
            return this.resolveCharEnt();
        }
        if (checkStd) {
            if (c == 'a') {
                char d = this.mInputBuffer[this.mInputPtr + 1];
                if (d == 'm') {
                    if (avail >= 4 && this.mInputBuffer[this.mInputPtr + 2] == 'p' && this.mInputBuffer[this.mInputPtr + 3] == ';') {
                        this.mInputPtr += 4;
                        return '&';
                    }
                } else if (d == 'p' && avail >= 5 && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 's' && this.mInputBuffer[this.mInputPtr + 4] == ';') {
                    this.mInputPtr += 5;
                    return '\'';
                }
            } else if (c == 'l') {
                if (avail >= 3 && this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';') {
                    this.mInputPtr += 3;
                    return '<';
                }
            } else if (c == 'g') {
                if (avail >= 3 && this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';') {
                    this.mInputPtr += 3;
                    return '>';
                }
            } else if (c == 'q' && avail >= 5 && this.mInputBuffer[this.mInputPtr + 1] == 'u' && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 't' && this.mInputBuffer[this.mInputPtr + 4] == ';') {
                this.mInputPtr += 5;
                return '\"';
            }
        }
        return '\u0000';
    }

    protected WEntityDeclaration resolveNonCharEntity(Map ent1, Map ent2) throws IOException, WstxException {
        WEntityDeclaration ed;
        char d;
        char c;
        int avail = this.mInputLen - this.mInputPtr;
        if (avail < 6) {
            --this.mInputPtr;
            if (!this.ensureInput(6)) {
                avail = this.inputInBuffer();
                if (avail < 3) {
                    this.throwUnexpectedEOF(" in entity reference");
                }
            } else {
                avail = 6;
            }
            ++this.mInputPtr;
        }
        if ((c = this.mInputBuffer[this.mInputPtr]) == '#') {
            return null;
        }
        if (c == 'a' ? ((d = this.mInputBuffer[this.mInputPtr + 1]) == 'm' ? avail >= 4 && this.mInputBuffer[this.mInputPtr + 2] == 'p' && this.mInputBuffer[this.mInputPtr + 3] == ';' : d == 'p' && avail >= 5 && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 's' && this.mInputBuffer[this.mInputPtr + 4] == ';') : (c == 'l' ? avail >= 3 && this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';' : (c == 'g' ? avail >= 3 && this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';' : c == 'q' && avail >= 5 && this.mInputBuffer[this.mInputPtr + 1] == 'u' && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 't' && this.mInputBuffer[this.mInputPtr + 4] == ';'))) {
            return null;
        }
        ++this.mInputPtr;
        String id = this.parseFullName(c);
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in entity reference");
        if (c != ';') {
            this.throwUnexpectedChar(c, "; expected a semi-colon after entity reference.");
        }
        if ((ed = ent1 != null ? (WEntityDeclaration)ent1.get(id) : null) == null) {
            if (ent2 != null) {
                ed = (WEntityDeclaration)ent2.get(id);
            }
            if (ed == null) {
                this.throwParseError("Undeclared entity '" + id + "'.");
            }
        }
        return ed;
    }

    protected char fullyResolveEntity(Map ent1, Map ent2, boolean allowExt) throws IOException, XMLStreamException {
        char c = this.getNextChar(" in entity reference");
        if (c == '#') {
            return this.resolveCharEnt();
        }
        String id = this.parseEntityName(c);
        if ((c = id.charAt(0)) == 'a') {
            if (id.equals("amp")) {
                return '&';
            }
            if (id.equals("apos")) {
                return '\'';
            }
        } else if (c == 'g') {
            if (id.length() == 2 && id.charAt(1) == 't') {
                return '>';
            }
        } else if (c == 'l') {
            if (id.length() == 2 && id.charAt(1) == 't') {
                return '<';
            }
        } else if (c == 'q' && id.equals("quot")) {
            return '\"';
        }
        this.expandEntity(id, ent1, ent2, allowExt);
        return '\u0000';
    }

    protected int expandEntity(String id, Map ent1, Map ent2, boolean allowExt) throws IOException, XMLStreamException {
        int result;
        WEntityDeclaration ed = ent1 == null ? null : (WEntityDeclaration)ent1.get(id);
        if (ed == null) {
            result = 2;
            if (ent2 != null) {
                ed = (WEntityDeclaration)ent2.get(id);
            }
        } else {
            result = 1;
        }
        if (ed == null) {
            this.throwParseError("Undeclared entity '" + id + "'.");
        }
        this.expandEntity(ed, allowExt);
        return result;
    }

    protected void expandEntity(WEntityDeclaration ed, boolean allowExt) throws IOException, XMLStreamException {
        boolean isExt;
        if (!ed.isParsed()) {
            this.throwParseError("Illegal reference to unparsed external entity '" + ed.getName() + "'.");
        }
        if (isExt = ed.isExternal()) {
            if (!allowExt) {
                this.throwParseError("Encountered a reference to external parsed entity '" + ed.getName() + "' when expanding attribute value: not legal as per XML 1.0/1.1 #3.1.");
            }
            if (!this.mConfig.hasConfigFlags(8)) {
                this.throwParseError("Encountered a reference to external entity '" + ed.getName() + "', but Reader has feature '" + "javax.xml.stream.isSupportingExternalEntities" + "' disabled.");
            }
        }
        WstxInputSource oldInput = this.mInput;
        oldInput.saveContext(this);
        WstxInputSource newInput = ed.createInputSource(this.mInput, this.mEntityResolver);
        if (newInput.hasRecursion()) {
            this.throwParseError("Illegal entity expansion: entity '" + ed.getName() + "' expands itself recursively.");
        }
        this.initInputSource(newInput, isExt);
    }

    protected static final boolean isNameStartChar(char c) {
        if (c < '\u0100') {
            if (c <= ' ') {
                return false;
            }
            return sCharValidity[c] == 1;
        }
        if (c <= '\u2fef') {
            if (c < '\u0300' || c >= '\u2c00') {
                return true;
            }
            if (c < '\u0370' || c > '\u218f') {
                return false;
            }
            if (c < '\u2000') {
                return c != '\u037e';
            }
            if (c >= '\u2070') {
                return c <= '\u218f';
            }
            return c == '\u200c' || c == '\u200d';
        }
        if (c >= '\u3001') {
            if (c <= '\udbff') {
                return true;
            }
            if (c >= '\uf900' && c <= '\ufffd') {
                return c <= '\ufdcf' || c >= '\ufdf0';
            }
        }
        return false;
    }

    protected static final boolean isNameChar(char c) {
        if (c < '\u0100') {
            if (c <= ' ') {
                return false;
            }
            return sCharValidity[c] != 0;
        }
        if (c <= '\u2fef') {
            if (c < '\u2000' || c >= '\u2c00') {
                return true;
            }
            if (c < '\u200c' || c > '\u218f') {
                return false;
            }
            if (c >= '\u2070') {
                return true;
            }
            return c == '\u200c' || c == '\u200d' || c == '\u203f' || c == '\u2040';
        }
        if (c >= '\u3001') {
            if (c <= '\udfff') {
                return true;
            }
            if (c >= '\uf900' && c <= '\ufffd') {
                return c <= '\ufdcf' || c >= '\ufdf0';
            }
        }
        return false;
    }

    protected static final boolean isSpaceChar(char c) {
        return c <= ' ';
    }

    protected String parseLocalName(char c) throws IOException, WstxException {
        int ptr;
        if (!StreamScanner.isNameStartChar((char)c)) {
            if (c == 58) {
                this.throwUnexpectedChar(c, " (missing namespace prefix?)");
            }
            this.throwUnexpectedChar(c, " (expected a name start character)");
        }
        int inputLen = this.mInputLen;
        int startPtr = ptr - 1;
        int hash = c;
        for (ptr = this.mInputPtr; ptr < inputLen; ++ptr) {
            c = this.mInputBuffer[ptr];
            if (c < 45 || !StreamScanner.isNameChar((char)c)) {
                this.mInputPtr = ptr;
                return this.mSymbols.findSymbol(this.mInputBuffer, startPtr, ptr - startPtr, hash);
            }
            hash = hash * 31 + c;
        }
        this.mInputPtr = ptr;
        return this.parseLocalName2(startPtr, hash);
    }

    protected String parseLocalName2(int start, int hash) throws IOException, WstxException {
        int ptr = this.mInputLen - start;
        char[] outBuf = this.getNameBuffer(ptr);
        if (ptr > 0) {
            System.arraycopy(this.mInputBuffer, start, outBuf, 0, ptr);
        }
        int outLen = outBuf.length;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in name token");
            if (c < '-' || !StreamScanner.isNameChar(c)) {
                --this.mInputPtr;
                break;
            }
            if (ptr >= outLen) {
                outBuf = this.expandBy50Pct(outBuf);
                this.mNameBuffer = outBuf;
                outLen = outBuf.length;
            }
            outBuf[ptr++] = c;
            hash = hash * 31 + c;
        }
        return this.mSymbols.findSymbol(outBuf, 0, ptr, hash);
    }

    protected String parseFullName() throws IOException, WstxException {
        return this.parseFullName(this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier"));
    }

    protected String parseFullName(char c) throws IOException, WstxException {
        if (!StreamScanner.isNameStartChar((char)c)) {
            if (c == 58) {
                if (this.mCfgNsEnabled) {
                    this.throwNsColonException(this.parseFNameForError());
                }
            } else {
                if (c <= 32) {
                    this.throwUnexpectedChar(c, " (missing name?)");
                }
                this.throwUnexpectedChar(c, " (expected a name start character)");
            }
        }
        int hash = c;
        int ptr = this.mInputPtr;
        int inputLen = this.mInputLen;
        char[] inputBuf = this.mInputBuffer;
        int startPtr = ptr - 1;
        while (true) {
            if (ptr >= inputLen) {
                this.mInputPtr = ptr;
                return this.parseFullName2(startPtr, hash);
            }
            c = inputBuf[ptr];
            if (c == 58) {
                if (this.mCfgNsEnabled) {
                    this.mInputPtr = ptr;
                    this.throwNsColonException(new String(inputBuf, startPtr, ptr - startPtr) + this.parseFNameForError());
                }
            } else if (!StreamScanner.isNameChar((char)c)) break;
            hash = hash * 31 + c;
            ++ptr;
        }
        this.mInputPtr = ptr;
        return this.mSymbols.findSymbol(inputBuf, startPtr, ptr - startPtr, hash);
    }

    protected String parseFullName2(int start, int hash) throws IOException, WstxException {
        int ptr = this.mInputLen - start;
        char[] outBuf = this.getNameBuffer(ptr);
        if (ptr > 0) {
            System.arraycopy(this.mInputBuffer, start, outBuf, 0, ptr);
        }
        int outLen = outBuf.length;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in name token");
            if (c == ':') {
                if (this.mCfgNsEnabled) {
                    this.throwNsColonException(new String(outBuf, 0, ptr) + c + this.parseFNameForError());
                }
            } else if (!StreamScanner.isNameChar(c)) {
                --this.mInputPtr;
                break;
            }
            if (ptr >= outLen) {
                outBuf = this.expandBy50Pct(outBuf);
                this.mNameBuffer = outBuf;
                outLen = outBuf.length;
            }
            outBuf[ptr++] = c;
            hash = hash * 31 + c;
        }
        return this.mSymbols.findSymbol(outBuf, 0, ptr, hash);
    }

    protected String parseFNameForError() throws IOException, WstxException {
        StringBuffer sb = new StringBuffer(100);
        while (true) {
            char c;
            if (this.mInputPtr < this.mInputLen) {
                c = this.mInputBuffer[this.mInputPtr++];
            } else {
                int i = this.getNext();
                if (i < 0) break;
                c = (char)i;
            }
            if (c != ':' && !StreamScanner.isNameChar(c)) {
                --this.mInputPtr;
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String parseEntityName(char c) throws IOException, WstxException {
        String id = this.parseFullName(c);
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in entity reference");
        if (c != ';') {
            this.throwUnexpectedChar(c, "; expected a semi-colon after entity reference.");
        }
        return id;
    }

    protected int skipFullName(char c) throws IOException, WstxException {
        if (!StreamScanner.isNameStartChar(c)) {
            --this.mInputPtr;
            return 0;
        }
        int count = 1;
        while (true) {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
            if (c != ':' && !StreamScanner.isNameChar(c)) break;
            ++count;
        }
        return count;
    }

    protected final String parseSystemId(char quoteChar, boolean convertLFs, String errorMsg) throws IOException, WstxException {
        char[] buf = this.getNameBuffer(-1);
        int ptr = 0;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
            if (c == quoteChar) break;
            if (c == '\n') {
                this.markLF();
            } else if (c == '\r') {
                if (this.peekNext() == 10) {
                    ++this.mInputPtr;
                    if (!convertLFs) {
                        if (ptr >= buf.length) {
                            buf = this.expandBy50Pct(buf);
                        }
                        buf[ptr++] = 13;
                    }
                    c = '\n';
                } else if (convertLFs) {
                    c = '\n';
                }
            }
            if (ptr >= buf.length) {
                buf = this.expandBy50Pct(buf);
            }
            buf[ptr++] = c;
        }
        return ptr == 0 ? "" : new String(buf, 0, ptr);
    }

    protected final String parsePublicId(char quoteChar, boolean convertLFs, String errorMsg) throws IOException, WstxException {
        char[] buf = this.getNameBuffer(-1);
        int ptr = 0;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
            if (c == quoteChar) break;
            if (c == '\n') {
                this.markLF();
            } else if (c == '\r') {
                if (this.peekNext() == 10) {
                    ++this.mInputPtr;
                    if (!convertLFs) {
                        if (ptr >= buf.length) {
                            buf = this.expandBy50Pct(buf);
                        }
                        buf[ptr++] = 13;
                    }
                    c = '\n';
                } else if (convertLFs) {
                    c = '\n';
                }
            } else if (c >= '\u0080' || sPubidValidity[c] != 1) {
                this.throwUnexpectedChar(c, " in public identifier");
            }
            if (ptr >= buf.length) {
                buf = this.expandBy50Pct(buf);
            }
            buf[ptr++] = c;
        }
        return ptr == 0 ? "" : new String(buf, 0, ptr);
    }

    protected final void parseUntil(TextBuffer tb, char endChar, boolean convertLFs, String errorMsg) throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore(errorMsg);
        }
        while (true) {
            int ptr;
            char[] inputBuf = this.mInputBuffer;
            int inputLen = this.mInputLen;
            int startPtr = ptr = this.mInputPtr;
            while (ptr < inputLen) {
                int thisLen;
                char c;
                if ((c = inputBuf[ptr++]) == endChar) {
                    thisLen = ptr - startPtr - 1;
                    if (thisLen > 0) {
                        tb.append(inputBuf, startPtr, thisLen);
                    }
                    this.mInputPtr = ptr;
                    return;
                }
                if (c == '\n') {
                    this.mInputPtr = ptr;
                    this.markLF();
                    continue;
                }
                if (c != '\r') continue;
                if (!convertLFs && ptr < inputLen) {
                    if (inputBuf[ptr] == '\n') {
                        // empty if block
                    }
                    this.mInputPtr = ++ptr;
                    this.markLF();
                    continue;
                }
                thisLen = ptr - startPtr - 1;
                if (thisLen > 0) {
                    tb.append(inputBuf, startPtr, thisLen);
                }
                this.mInputPtr = ptr;
                c = this.getNextChar(errorMsg);
                if (c != '\n') {
                    --this.mInputPtr;
                    tb.append(convertLFs ? (char)'\n' : '\r');
                } else if (convertLFs) {
                    tb.append('\n');
                } else {
                    tb.append('\r');
                    tb.append('\n');
                }
                startPtr = ptr = this.mInputPtr;
                this.markLF();
            }
            int thisLen = ptr - startPtr;
            if (thisLen > 0) {
                tb.append(inputBuf, startPtr, thisLen);
            }
            this.loadMore(errorMsg);
            startPtr = ptr = this.mInputPtr;
            inputBuf = this.mInputBuffer;
            inputLen = this.mInputLen;
        }
    }

    private char resolveCharEnt() throws IOException, WstxException {
        int value = 0;
        char c = this.getNextChar(" in entity reference");
        if (c == 'x') {
            while (true) {
                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in entity reference");
                if (c != ';') {
                    value <<= 4;
                    if (c <= '9' && c >= '0') {
                        value += c - 48;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        value += 10 + (c - 97);
                        continue;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        value += 10 + (c - 65);
                        continue;
                    }
                    this.throwUnexpectedChar(c, "; expected a hex number (0-9a-zA-Z).");
                    continue;
                }
                break;
            }
        } else {
            while (c != ';') {
                if (c <= '9' && c >= '0') {
                    value = value * 10 + (c - 48);
                } else {
                    this.throwUnexpectedChar(c, "; expected a decimal number.");
                }
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in entity reference");
            }
        }
        c = (char)value;
        if (value == 0) {
            this.throwParseError("Invalid character reference -- null character not allowed in XML content.");
        }
        return c;
    }

    protected final char[] getNameBuffer(int minSize) {
        char[] buf = this.mNameBuffer;
        if (buf == null) {
            this.mNameBuffer = buf = new char[minSize > 48 ? minSize + 16 : 64];
        } else if (minSize >= buf.length) {
            int len = buf.length;
            this.mNameBuffer = buf = new char[minSize >= (len += len >> 1) ? minSize + 16 : len];
        }
        return buf;
    }

    protected final char[] expandBy50Pct(char[] buf) {
        int len = buf.length;
        char[] newBuf = new char[len + (len >> 1)];
        System.arraycopy(buf, 0, newBuf, 0, len);
        return newBuf;
    }

    private void throwNsColonException(String name) throws WstxParsingException {
        this.throwParseError("Illegal name '" + name + "' (PI target, entity/notation name): can not contain a colon (XML Namespaces 1.0#6)");
    }

    static {
        int i;
        sCharValidity = new byte[256];
        StreamScanner.sCharValidity[95] = 1;
        int last = 25;
        for (i = 0; i <= last; ++i) {
            StreamScanner.sCharValidity[65 + i] = 1;
            StreamScanner.sCharValidity[97 + i] = 1;
        }
        for (i = 192; i < 246; ++i) {
            StreamScanner.sCharValidity[i] = 1;
        }
        StreamScanner.sCharValidity[215] = 0;
        StreamScanner.sCharValidity[247] = 0;
        StreamScanner.sCharValidity[45] = -1;
        StreamScanner.sCharValidity[46] = -1;
        StreamScanner.sCharValidity[183] = -1;
        for (i = 48; i <= 57; ++i) {
            StreamScanner.sCharValidity[i] = -1;
        }
        sPubidValidity = new byte[128];
        last = 25;
        for (i = 0; i <= last; ++i) {
            StreamScanner.sPubidValidity[65 + i] = 1;
            StreamScanner.sPubidValidity[97 + i] = 1;
        }
        for (i = 48; i <= 57; ++i) {
            StreamScanner.sPubidValidity[i] = 1;
        }
        StreamScanner.sPubidValidity[10] = 1;
        StreamScanner.sPubidValidity[13] = 1;
        StreamScanner.sPubidValidity[32] = 1;
        StreamScanner.sPubidValidity[45] = 1;
        StreamScanner.sPubidValidity[39] = 1;
        StreamScanner.sPubidValidity[40] = 1;
        StreamScanner.sPubidValidity[41] = 1;
        StreamScanner.sPubidValidity[43] = 1;
        StreamScanner.sPubidValidity[44] = 1;
        StreamScanner.sPubidValidity[46] = 1;
        StreamScanner.sPubidValidity[47] = 1;
        StreamScanner.sPubidValidity[58] = 1;
        StreamScanner.sPubidValidity[61] = 1;
        StreamScanner.sPubidValidity[63] = 1;
        StreamScanner.sPubidValidity[59] = 1;
        StreamScanner.sPubidValidity[33] = 1;
        StreamScanner.sPubidValidity[42] = 1;
        StreamScanner.sPubidValidity[35] = 1;
        StreamScanner.sPubidValidity[64] = 1;
        StreamScanner.sPubidValidity[36] = 1;
        StreamScanner.sPubidValidity[95] = 1;
        StreamScanner.sPubidValidity[37] = 1;
        sEntityLt = WEntityDeclInt.create("lt", "&#38;#60;");
        sEntityGt = WEntityDeclInt.create("gt", "&#62;");
        sEntityAmp = WEntityDeclInt.create("amp", "&#38;#38;");
        sEntityApos = WEntityDeclInt.create("apos", "&#39;");
        sEntityQuot = WEntityDeclInt.create("quot", "&#34;");
    }
}

