/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.stream;

import com.ctc.wstx.stax.cfg.OutputConfigFlags;
import com.ctc.wstx.stax.cfg.WriterConfig;
import com.ctc.wstx.stax.exc.WstxIOException;
import com.ctc.wstx.util.XMLQuoter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;

public abstract class BaseStreamWriter
implements XMLStreamWriter,
OutputConfigFlags {
    protected static final int STATE_PROLOG = 1;
    protected static final int STATE_TREE = 2;
    protected static final int STATE_EPILOG = 3;
    protected static final char CHAR_SPACE = ' ';
    protected final Writer mWriter;
    protected final boolean mCfgOutputEmptyElems;
    protected final boolean mCheckStructure;
    protected final boolean mCheckContent;
    protected final boolean mCheckAttr;
    protected int mState = 1;
    protected boolean mAnyOutput = false;
    protected boolean mStartElementOpen = false;
    protected boolean mEmptyElement = false;

    protected BaseStreamWriter(Writer w, WriterConfig cfg) {
        this.mWriter = w;
        int flags = cfg.getConfigFlags();
        this.mCheckStructure = (flags & 0x10) != 0;
        this.mCheckContent = (flags & 0x20) != 0;
        this.mCheckAttr = (flags & 0x40) != 0;
        this.mCfgOutputEmptyElems = (flags & 4) != 0;
    }

    public void close() throws XMLStreamException {
        if (this.mState != 3) {
            this.writeEndDocument();
        }
        this.flush();
    }

    public void flush() throws XMLStreamException {
        try {
            this.mWriter.flush();
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract NamespaceContext getNamespaceContext();

    public abstract String getPrefix(String var1);

    public Object getProperty(String name) {
        return null;
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void setNamespaceContext(NamespaceContext var1);

    public abstract void setPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeCData(String data) throws XMLStreamException {
        int ix;
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            throw new IllegalStateException("Trying to output a CDATA block outside main element tree (in prolog or epilog)");
        }
        if (this.mCheckContent && data != null && data.length() > 1 && (ix = data.indexOf(93)) >= 0 && (ix = data.indexOf("]]>", ix)) >= 0) {
            throw new XMLStreamException("Illegal input: CDATA block has embedded ']]>' in it (index " + ix + ")");
        }
        try {
            this.mWriter.write("<![CDATA[");
            if (data != null) {
                this.mWriter.write(data);
            }
            this.mWriter.write("]]>");
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog() && !XMLQuoter.isAllWhitespace(text, start, len)) {
            throw new IllegalStateException("Trying to output non-whitespace characters outside main element tree (in prolog or epilog)");
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            XMLQuoter.outputXMLText(this.mWriter, text, start, len);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog() && !XMLQuoter.isAllWhitespace(text)) {
            throw new IllegalStateException("Trying to output non-whitespace characters outside main element tree (in prolog or epilog)");
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            XMLQuoter.outputXMLText(this.mWriter, text);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        int ix;
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckContent && (ix = data.indexOf(45)) >= 0 && (ix = data.indexOf("--", ix)) >= 0) {
            throw new XMLStreamException("Illegal input: comment content has embedded '--' in it (index " + ix + ")");
        }
        try {
            this.mWriter.write("<!--");
            this.mWriter.write(data);
            this.mWriter.write("-->");
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public void writeDTD(String dtd) throws XMLStreamException {
        try {
            this.mWriter.write(dtd);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void writeEmptyElement(String var1) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    public void writeEndDocument() throws XMLStreamException {
        if (this.mState != 3) {
            if (this.mCheckStructure && this.mState == 1) {
                throw new IllegalStateException("Trying to write END_DOCUMENT when document has no root (ie. trying to output empty document).");
            }
            if (this.mStartElementOpen) {
                this.closeStartElement(this.mEmptyElement);
            }
            while (this.mState != 3) {
                this.writeEndElement();
            }
        }
    }

    public abstract void writeEndElement() throws XMLStreamException;

    public void writeEntityRef(String name) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            throw new IllegalStateException("Trying to output an entity reference outside main element tree (in prolog or epilog)");
        }
        if (this.mCheckContent) {
            this.checkNameValidity(name, true);
        }
        try {
            this.mWriter.write(38);
            this.mWriter.write(name);
            this.mWriter.write(59);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckContent) {
            int ix;
            this.checkNameValidity(target, true);
            if (data != null && data.length() > 1 && (ix = data.indexOf(63)) >= 0 && (ix = data.indexOf("?>", ix)) >= 0) {
                throw new XMLStreamException("Illegal input: processing instruction content has embedded '?>' in it (index " + ix + ")");
            }
        }
        try {
            this.mWriter.write("<?");
            this.mWriter.write(target);
            if (data != null && data.length() > 0) {
                if (data.charAt(0) > ' ') {
                    this.mWriter.write(32);
                }
                this.mWriter.write(data);
            }
            this.mWriter.write("?>");
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.mCheckStructure && this.mAnyOutput) {
            throw new IllegalStateException("Can not output XML declaration, after other output has already been done.");
        }
        this.mAnyOutput = true;
        if (this.mCheckContent) {
            if (encoding != null) {
                // empty if block
            }
            if (version != null) {
                // empty if block
            }
        }
        try {
            this.mWriter.write("<?xml version=\"");
            this.mWriter.write(version == null || version.length() == 0 ? "1.0" : version);
            this.mWriter.write(34);
            if (encoding != null && encoding.length() > 0) {
                this.mWriter.write(" encoding=\"");
                this.mWriter.write(encoding);
                this.mWriter.write(34);
            }
            this.mWriter.write(" ?>");
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void writeStartElement(String var1) throws XMLStreamException;

    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    public Writer getWriter() {
        return this.mWriter;
    }

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    public abstract void writeEndElement(QName var1) throws XMLStreamException;

    public void writeCharacters(Characters ch) throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog() && !ch.isIgnorableWhiteSpace() && !ch.isWhiteSpace()) {
            throw new IllegalStateException("Trying to output non-whitespace characters outside main element tree (in prolog or epilog)");
        }
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            XMLQuoter.outputXMLText(this.mWriter, ch.getData());
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void closeStartElement(boolean var1) throws XMLStreamException;

    public boolean inPrologOrEpilog() {
        return this.mState != 2;
    }

    public void checkNameValidity(String name, boolean allowColons) {
        if (!allowColons && name.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Illegal name token '" + name + "'; colons not allowed inside names, only a single colon allowed to indicate fully-qualified name.");
        }
    }

    public abstract String getTopElemName();

    protected void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    protected void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        throw new XMLStreamException(msg);
    }

    protected void throwFromIOE(IOException ioe) throws XMLStreamException {
        throw new WstxIOException(ioe);
    }
}

