/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.ns;

import com.ctc.wstx.stax.evt.WAttrList;
import com.ctc.wstx.stax.ns.AttributeCollector;
import com.ctc.wstx.stax.stream.StreamScanner;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

final class NsAttributeCollector
extends AttributeCollector {
    protected static final String DEFAULT_NS_URI = "";
    static final int EXP_NS_COUNT = 12;
    final String mXmlPrefix;
    final String mXmlnsPrefix;
    private final TextBuilder mNamespaceURIs = new TextBuilder(12);
    private final StringVector mNsPrefixes = new StringVector(12);
    private boolean mDefaultNsDeclared = false;
    protected int mAttrCount;
    protected final TextBuilder mValueBuffer = new TextBuilder(32);
    private final StringVector mAttrNames = new StringVector(64);
    private String[] mAttrURIs = null;
    private String[] mAttrValues = null;
    private int[] mAttrMap = null;
    private int mAttrHashSize;
    private int mAttrSpillEnd;

    public NsAttributeCollector(String xmlPrefix, String xmlnsPrefix) {
        this.mXmlPrefix = xmlPrefix;
        this.mXmlnsPrefix = xmlnsPrefix;
    }

    protected void reset() {
        this.mValueBuffer.reset();
        this.mNamespaceURIs.reset();
        this.mDefaultNsDeclared = false;
        this.mAttrNames.clear(false);
        this.mNsPrefixes.clear(false);
        this.mAttrCount = 0;
    }

    protected void resolveNamespaces(StreamScanner sc, StringVector ns) throws XMLStreamException {
        int hashCount;
        int i;
        String[] attrURIs;
        int attrCount = this.mAttrCount;
        if (attrCount < 1) {
            this.mAttrHashSize = 0;
        }
        if ((attrURIs = this.mAttrURIs) == null || attrURIs.length < attrCount) {
            this.mAttrURIs = attrURIs = new String[attrCount];
        }
        String[] attrNames = this.mAttrNames.getInternalArray();
        for (i = 0; i < attrCount; ++i) {
            String prefix = attrNames[i + i];
            if (prefix == null || prefix.length() == 0) {
                attrURIs[i] = DEFAULT_NS_URI;
                continue;
            }
            if (prefix == this.mXmlPrefix) {
                attrURIs[i] = "http://www.w3.org/XML/1998/namespace";
                continue;
            }
            String uri = ns.findLastFromMap(prefix);
            if (uri == null) {
                sc.throwParseError("Undeclared namespace prefix '" + prefix + "' for attribute '" + attrNames[i + i + 1] + "'.");
            }
            attrURIs[i] = uri;
        }
        if (this.mAttrValues != null) {
            if (this.mAttrValues.length < attrCount) {
                this.mAttrValues = null;
            } else {
                for (i = 0; i < attrCount; ++i) {
                    this.mAttrValues[i] = null;
                }
            }
        }
        int[] map = this.mAttrMap;
        int min = attrCount + (attrCount >> 2);
        for (hashCount = 4; hashCount < min; hashCount += hashCount) {
        }
        this.mAttrHashSize = hashCount;
        min = hashCount + (hashCount >> 4);
        if (map == null || map.length < min) {
            map = new int[min];
        } else {
            for (int i2 = 0; i2 < hashCount; ++i2) {
                map[i2] = 0;
            }
        }
        int mask = hashCount - 1;
        int spillIndex = hashCount;
        for (int i3 = 0; i3 < attrCount; ++i3) {
            int index;
            String uri = attrURIs[i3];
            String name = attrNames[i3 + i3 + 1];
            int hash = name.hashCode();
            if (uri.length() > 0) {
                hash ^= uri.hashCode();
            }
            if (map[index = hash & mask] == 0) {
                map[index] = i3 + 1;
                continue;
            }
            int currIndex = map[index] - 1;
            if ((map = this.spillAttr(uri, name, map, currIndex, spillIndex, attrCount, hash, hashCount)) == null) {
                this.throwDupAttr(sc, currIndex);
            }
            map[++spillIndex] = i3;
            ++spillIndex;
        }
        this.mAttrSpillEnd = spillIndex;
        this.mAttrMap = map;
    }

    public int getNsCount() {
        return this.mNamespaceURIs.size();
    }

    public boolean hasDefaultNs() {
        return this.mDefaultNsDeclared;
    }

    public String getNsPrefix(int index) {
        return this.mNsPrefixes.getString(index);
    }

    public String getNsURI(int index) {
        return this.mNamespaceURIs.getEntry(index);
    }

    public int getCount() {
        return this.mAttrCount;
    }

    public String getPrefix(int index) {
        return this.mAttrNames.getString(index << 1);
    }

    public String getLocalName(int index) {
        return this.mAttrNames.getString((index << 1) + 1);
    }

    public String getURI(int index) {
        return this.mAttrURIs[index];
    }

    public QName getQName(int index) {
        String prefix = this.getPrefix(index);
        if (prefix == null) {
            prefix = DEFAULT_NS_URI;
        }
        return new QName(this.getURI(index), this.getLocalName(index), prefix);
    }

    public String getValue(int index) {
        String str;
        if (index < 0 || index >= this.mAttrCount) {
            throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + this.mAttrCount + " attributes.");
        }
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[this.mAttrCount];
        }
        if ((str = this.mAttrValues[index]) == null) {
            this.mAttrValues[index] = str = this.mValueBuffer.getEntry(index);
        }
        return str;
    }

    public String getValue(String nsURI, String localName) {
        String thisURI;
        String thisName;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return null;
        }
        int hash = localName.hashCode();
        if (nsURI == null) {
            nsURI = DEFAULT_NS_URI;
        } else if (nsURI.length() > 0) {
            hash ^= nsURI.hashCode();
        }
        int ix = this.mAttrMap[hash & hashSize - 1];
        if (ix == 0) {
            return null;
        }
        if (((thisName = this.mAttrNames.getString(--ix + ix + 1)) == localName || thisName.equals(localName)) && ((thisURI = this.mAttrURIs[ix]) == nsURI || thisURI.equals(nsURI))) {
            return this.getValue(ix);
        }
        int len = this.mAttrSpillEnd;
        for (int i = hashSize; i < len; i += 2) {
            String thisURI2;
            if (this.mAttrMap[i] != hash || (thisName = this.mAttrNames.getString((ix = this.mAttrMap[i + 1]) + ix + 1)) != localName && !thisName.equals(localName) || (thisURI2 = this.mAttrURIs[ix]) != nsURI && !thisURI2.equals(nsURI)) continue;
            return this.getValue(ix);
        }
        return null;
    }

    public TextBuilder getDefaultNsBuilder() {
        if (this.mDefaultNsDeclared) {
            return null;
        }
        this.mDefaultNsDeclared = true;
        this.mNsPrefixes.addString(null);
        return this.mNamespaceURIs;
    }

    public TextBuilder getNsBuilder(String prefix) {
        if (this.mNsPrefixes.containsInterned(prefix)) {
            return null;
        }
        this.mNsPrefixes.addString(prefix);
        return this.mNamespaceURIs;
    }

    public TextBuilder getAttrBuilder(String attrPrefix, String attrLocalName) {
        ++this.mAttrCount;
        this.mAttrNames.addStrings(attrPrefix, attrLocalName);
        return this.mValueBuffer;
    }

    protected String[] getNsPrefixes() {
        return this.mNsPrefixes.getInternalArray();
    }

    public TextBuilder getNsURIs() {
        return this.mNamespaceURIs;
    }

    public WAttrList buildAttrList(Location loc) {
        int count = this.mAttrCount;
        if (count == 0) {
            return new WAttrList(loc);
        }
        String[] raw = new String[count << 2];
        for (int i = 0; i < count; ++i) {
            int ix = i << 2;
            raw[ix] = this.mAttrNames.getString(i + i + 1);
            raw[ix + 1] = this.mAttrURIs[i];
            raw[ix + 2] = this.mAttrNames.getString(i + i);
            raw[ix + 3] = this.getValue(i);
        }
        if (count < 4) {
            return new WAttrList(loc, raw);
        }
        return new WAttrList(loc, raw, this.mAttrMap, this.mAttrHashSize, this.mAttrSpillEnd);
    }

    private int[] spillAttr(String uri, String name, int[] map, int currIndex, int spillIndex, int attrCount, int hash, int hashCount) {
        String currURI;
        if (this.mAttrNames.getString(currIndex + currIndex + 1) == name && ((currURI = this.mAttrURIs[currIndex]) == uri || currURI.equals(uri))) {
            return null;
        }
        if (spillIndex + 1 >= map.length) {
            int[] old = map;
            map = new int[old.length + 8];
            System.arraycopy(old, 0, map, 0, old.length);
        }
        for (int j = hashCount; j < spillIndex; j += 2) {
            String currURI2;
            if (map[j] != hash || this.mAttrNames.getString((currIndex = map[j + 1]) + currIndex + 1) != name || (currURI2 = this.mAttrURIs[currIndex]) != uri && !currURI2.equals(uri)) continue;
            return null;
        }
        map[spillIndex] = hash;
        return map;
    }
}

