/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.ns;

import com.ctc.wstx.stax.ns.AttributeCollector;
import com.ctc.wstx.stax.ns.BaseNsContext;
import com.ctc.wstx.stax.ns.EmptyNamespaceContext;
import com.ctc.wstx.stax.ns.InputElementStack;
import com.ctc.wstx.stax.ns.NonNsAttributeCollector;
import com.ctc.wstx.stax.stream.StreamScanner;
import com.ctc.wstx.util.EmptyIterator;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class NonNsInputElementStack
extends InputElementStack {
    private final NonNsAttributeCollector mAttrCollector;
    protected String[] mElements;
    protected int mSize = 0;

    public NonNsInputElementStack(int initialSize) {
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.mElements = new String[initialSize];
        this.mAttrCollector = new NonNsAttributeCollector();
    }

    public final void push(String prefix, String localName) {
        throw new Error("Internal error: push(prefix, localName) shouldn't be called for non-namespace element stack.");
    }

    public final void push(String fullName) {
        if (this.mSize == this.mElements.length) {
            String[] old = this.mElements;
            this.mElements = new String[old.length + 32];
            System.arraycopy(old, 0, this.mElements, 0, old.length);
        }
        this.mElements[this.mSize] = fullName;
        ++this.mSize;
        this.mAttrCollector.reset();
    }

    public int pop() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        this.mElements[--this.mSize] = null;
        return 3;
    }

    public int resolveElem(StreamScanner sc, boolean internNsURIs) throws XMLStreamException {
        this.mAttrCollector.resolveValues(sc);
        return 3;
    }

    public final int getDepth() {
        return this.mSize;
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public final BaseNsContext createNonTransientNsContext(Location loc) {
        return EmptyNamespaceContext.getInstance();
    }

    public final String getNamespaceURI(String prefix) {
        return null;
    }

    public final String getPrefix(String nsURI) {
        return null;
    }

    public final Iterator getPrefixes(String nsURI) {
        return EmptyIterator.getInstance();
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final String getDefaultNsURI() {
        return null;
    }

    public final String getNsURI() {
        return null;
    }

    public final String getPrefix() {
        return null;
    }

    public final String getLocalName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final QName getQName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return new QName(this.mElements[this.mSize - 1]);
    }

    public final boolean matches(String prefix, String localName) {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        if (prefix != null && prefix.length() > 0) {
            return false;
        }
        String thisName = this.mElements[this.mSize - 1];
        return thisName == localName || thisName.equals(localName);
    }

    public final String getTopElementDesc() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final int getTotalNsCount() {
        return 0;
    }

    public final int getCurrentNsCount() {
        return 0;
    }

    public final String getLocalNsPrefix(int index) {
        throw new IllegalArgumentException("Illegal namespace index " + index + "; current scope has no namespace declarations.");
    }

    public final String getLocalNsURI(int index) {
        throw new IllegalArgumentException("Illegal namespace index " + index + "; current scope has no namespace declarations.");
    }
}

