/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.io;

import com.ctc.wstx.stax.io.WstxInputData;
import com.ctc.wstx.stax.io.WstxInputLocation;
import com.ctc.wstx.stax.io.WstxInputSource;
import java.io.IOException;
import java.net.URL;

public abstract class BaseInputSource
extends WstxInputSource {
    final String mPublicId;
    final String mSystemId;
    final URL mSource;
    protected char[] mBuffer;
    protected int mInputLen;
    int mSavedInputProcessed = 0;
    int mSavedInputRow = 1;
    int mSavedInputRowStart = 0;
    int mSavedInputPtr = 0;

    protected BaseInputSource(WstxInputSource parent, String fromEntity, String publicId, String systemId, URL src) {
        super(parent, fromEntity);
        this.mSystemId = systemId;
        this.mPublicId = publicId;
        this.mSource = src;
    }

    public abstract int getInputBufferLength();

    public URL getSource() {
        return this.mSource;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public abstract void initInputLocation(WstxInputData var1);

    public abstract int readInto(WstxInputData var1) throws IOException;

    public abstract boolean readMore(WstxInputData var1, int var2) throws IOException;

    public void saveContext(WstxInputData reader) {
        this.mSavedInputPtr = reader.mInputPtr;
        this.mSavedInputProcessed = reader.mCurrInputProcessed;
        this.mSavedInputRow = reader.mCurrInputRow;
        this.mSavedInputRowStart = reader.mCurrInputRowStart;
    }

    public void restoreContext(WstxInputData reader) {
        reader.mInputBuffer = this.mBuffer;
        reader.mInputLen = this.mInputLen;
        reader.mInputPtr = this.mSavedInputPtr;
        reader.mCurrInputProcessed = this.mSavedInputProcessed;
        reader.mCurrInputRow = this.mSavedInputRow;
        reader.mCurrInputRowStart = this.mSavedInputRowStart;
    }

    public abstract void close() throws IOException;

    public final WstxInputLocation getLocation() {
        return this.getLocation(this.mSavedInputProcessed + this.mSavedInputPtr - 1, this.mSavedInputRow, this.mSavedInputPtr - this.mSavedInputRowStart);
    }

    public final WstxInputLocation getLocation(int total, int row, int col) {
        WstxInputLocation pl = this.mParent == null ? null : this.mParent.getLocation();
        return new WstxInputLocation(pl, this.getPublicId(), this.getSystemId(), total, row, col);
    }
}

