/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.dtd;

import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.dtd.DTDElement;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.evt.WNotationDeclaration;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.exc.WstxParsingException;
import com.ctc.wstx.util.DataUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class DTDSubsetImpl
extends DTDSubset {
    final boolean mIsCachable;
    final Map mGeneralEntities;
    volatile transient List mGeneralEntityList = null;
    final Map mDefinedPEs;
    final Set mReferencedPEs;
    final Map mNotations;
    volatile transient List mNotationList = null;
    final Map mElements;

    private DTDSubsetImpl(boolean cachable, Map genEnt, Map paramEnt, Set peRefs, Map notations, Map elements) {
        this.mIsCachable = cachable;
        this.mGeneralEntities = genEnt;
        this.mDefinedPEs = paramEnt;
        this.mReferencedPEs = peRefs;
        this.mNotations = notations;
        this.mElements = elements;
    }

    public static DTDSubsetImpl constructInstance(boolean cachable, Map genEnt, Map paramEnt, Set refdPEs, Map notations, Map elements) {
        return new DTDSubsetImpl(cachable, genEnt, paramEnt, refdPEs, notations, elements);
    }

    public DTDSubset combineWithExternalSubset(DTDSubset extSubset, XMLReporter rep) throws WstxException {
        Map ge1 = this.getGeneralEntityMap();
        Map ge2 = extSubset.getGeneralEntityMap();
        if (ge1 == null || ge1.isEmpty()) {
            ge1 = ge2;
        } else if (ge2 != null && !ge2.isEmpty()) {
            DTDSubsetImpl.combineMaps(ge1, ge2);
        }
        Map n1 = this.getNotationMap();
        Map n2 = extSubset.getNotationMap();
        if (n1 == null || n1.isEmpty()) {
            n1 = n2;
        } else if (n2 != null && !n2.isEmpty()) {
            DTDSubsetImpl.checkNotations(n1, n2);
            DTDSubsetImpl.combineMaps(n1, n2);
        }
        Map e1 = this.getElementMap();
        Map e2 = extSubset.getElementMap();
        if (e1 == null || e1.isEmpty()) {
            e1 = e2;
        } else if (e2 != null && !e2.isEmpty()) {
            DTDSubsetImpl.combineElements(e1, e2, rep);
        }
        return DTDSubsetImpl.constructInstance(false, ge1, null, null, n1, e1);
    }

    public boolean isCachable() {
        return this.mIsCachable;
    }

    public Map getGeneralEntityMap() {
        return this.mGeneralEntities;
    }

    public List getGeneralEntityList() {
        List<Object> l = this.mGeneralEntityList;
        if (l == null) {
            l = this.mGeneralEntities == null || this.mGeneralEntities.size() == 0 ? JdkFeatures.getInstance().getEmptyList() : Collections.unmodifiableList(new ArrayList(this.mGeneralEntities.values()));
            this.mGeneralEntityList = l;
        }
        return l;
    }

    public Map getParameterEntityMap() {
        return this.mDefinedPEs;
    }

    public Map getNotationMap() {
        return this.mNotations;
    }

    public List getNotationList() {
        List<Object> l = this.mNotationList;
        if (l == null) {
            l = this.mNotations == null || this.mNotations.size() == 0 ? JdkFeatures.getInstance().getEmptyList() : Collections.unmodifiableList(new ArrayList(this.mNotations.values()));
            this.mNotationList = l;
        }
        return l;
    }

    public Map getElementMap() {
        return this.mElements;
    }

    public boolean isReusableWith(DTDSubset intSubset) {
        Map intPEs;
        Set refdPEs = this.mReferencedPEs;
        return refdPEs == null || refdPEs.size() <= 0 || (intPEs = intSubset.getParameterEntityMap()) == null || intPEs.size() <= 0 || !DataUtil.anyValuesInCommon(refdPEs, intPEs.keySet());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[DTDSubset: ");
        int count = this.mGeneralEntities == null ? 0 : this.mGeneralEntities.size();
        sb.append(count);
        sb.append(" general entities");
        sb.append(']');
        return sb.toString();
    }

    public static void throwNotationException(WNotationDeclaration oldDecl, WNotationDeclaration newDecl) throws WstxException {
        throw new WstxParsingException("Trying to redefine notation '" + newDecl.getName() + "' (originally defined at " + oldDecl.getLocation() + ")", newDecl.getLocation());
    }

    public static void throwElementException(DTDElement oldElem, Location loc) throws WstxException {
        throw new WstxParsingException("Trying to redefine element '" + oldElem.getDisplayName() + "' (originally defined at " + oldElem.getLocation() + ")", loc);
    }

    private static void combineMaps(Map m1, Map m2) {
        Iterator it = m2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object key = me.getKey();
            Object old = m1.put(key, me.getValue());
            if (old == null) continue;
            m1.put(key, old);
        }
    }

    private static void combineElements(Map intElems, Map extElems, XMLReporter rep) throws WstxException {
        Iterator it = extElems.entrySet().iterator();
        while (it.hasNext()) {
            Object extVal;
            Map.Entry me = it.next();
            Object key = me.getKey();
            Object oldVal = intElems.put(key, extVal = me.getValue());
            if (oldVal == null) continue;
            DTDElement extElem = (DTDElement)extVal;
            DTDElement intElem = (DTDElement)oldVal;
            if (extElem.isDefined()) {
                if (intElem.isDefined()) {
                    DTDSubsetImpl.throwElementException(intElem, extElem.getLocation());
                }
            } else if (!intElem.isDefined() && rep != null) {
                try {
                    rep.report(MessageFormat.format(ErrorConsts.W_UNDEFINED_ELEM, extElem.getDisplayName()), ErrorConsts.WT_ENT_DECL, intElem, intElem.getLocation());
                }
                catch (XMLStreamException foo) {
                    throw new Error(foo);
                }
            }
            intElem.mergeMissingAttributesFrom(extElem);
            intElems.put(key, intElem);
        }
    }

    private static void checkNotations(Map fromInt, Map fromExt) throws WstxException {
        Iterator it = fromExt.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            if (!fromInt.containsKey(en.getKey())) continue;
            DTDSubsetImpl.throwNotationException((WNotationDeclaration)fromInt.get(en.getKey()), (WNotationDeclaration)en.getValue());
        }
    }
}

