/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.dtd;

import com.ctc.wstx.stax.cfg.InputConfigFlags;
import com.ctc.wstx.stax.dtd.ContentSpec;
import com.ctc.wstx.stax.dtd.DTDAttribute;
import com.ctc.wstx.stax.dtd.NameKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.Location;

public final class DTDElement
implements InputConfigFlags {
    NameKey mName;
    Location mLocation;
    ContentSpec mContentSpec;
    final int mAllowedContent;
    HashMap mAttrs = null;

    public DTDElement(Location loc, NameKey name, ContentSpec spec) {
        this.mLocation = loc;
        this.mName = name;
        this.mContentSpec = spec;
        this.mAllowedContent = spec == null ? 3 : (spec.hasMixed() ? (spec.getArity() == 0 ? 2 : 3) : (spec.getArity() == 0 ? 0 : 1));
    }

    public void addAttribute(DTDAttribute attr) {
        HashMap<NameKey, DTDAttribute> m = this.mAttrs;
        if (m == null) {
            this.mAttrs = m = new HashMap<NameKey, DTDAttribute>();
        }
        m.put(attr.getName(), attr);
    }

    public void mergeMissingAttributesFrom(DTDElement other) {
        Map otherMap = other.getAttributes();
        HashMap m = this.mAttrs;
        if (m == null) {
            this.mAttrs = m = new HashMap();
        }
        if (otherMap != null && otherMap.size() > 0) {
            Iterator it = otherMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object key = me.getKey();
                if (m.containsKey(key)) continue;
                m.put(key, me.getValue());
            }
        }
    }

    public NameKey getName() {
        return this.mName;
    }

    public String toString() {
        return this.mName.toString();
    }

    public String getDisplayName() {
        return this.mName.toString();
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public void setLocation(Location loc) {
        this.mLocation = loc;
    }

    public ContentSpec getContentSpec() {
        return this.mContentSpec;
    }

    public void setContentSpec(ContentSpec spec) {
        this.mContentSpec = spec;
    }

    public boolean isDefined() {
        return this.mContentSpec != null;
    }

    public boolean canContainMixed() {
        return this.mContentSpec == null || this.mContentSpec.hasMixed();
    }

    public int getAllowedContent() {
        return this.mAllowedContent;
    }

    public Map getAttributes() {
        return this.mAttrs;
    }
}

