/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.dtd.DTDId;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.io.BranchingReaderSource;
import com.ctc.wstx.stax.io.DefaultInputResolver;
import com.ctc.wstx.stax.io.InputBootstrapper;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.io.WstxInputSource;
import com.ctc.wstx.stax.ns.InputElementStack;
import com.ctc.wstx.stax.ns.VNonNsInputElementStack;
import com.ctc.wstx.stax.ns.VNsInputElementStack;
import com.ctc.wstx.stax.stream.BasicStreamReader;
import com.ctc.wstx.stax.stream.ReaderCreator;
import com.ctc.wstx.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class WstxStreamReader
extends BasicStreamReader {
    static final String STAX_PROP_ENTITIES = "javax.xml.stream.entities";
    static final String STAX_PROP_NOTATIONS = "javax.xml.stream.notations";
    DTDSubset mDTD = null;

    private WstxStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputElementStack elemStack) throws IOException, XMLStreamException {
        super(input, owner, cfg, elemStack);
    }

    public static WstxStreamReader createWstxStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputBootstrapper bs) throws IOException, XMLStreamException {
        InputElementStack elemStack = !cfg.willValidateWithDTD() ? BasicStreamReader.createElementStack(cfg) : (cfg.willSupportNamespaces() ? new VNsInputElementStack(16, sPrefixXml, sPrefixXmlns) : new VNonNsInputElementStack(16));
        WstxStreamReader sr = new WstxStreamReader(input, owner, cfg, elemStack);
        sr.initProlog(bs);
        return sr;
    }

    public Object getProperty(String name) {
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 11 && this.mDTD != null) {
            if (name.equals(STAX_PROP_ENTITIES)) {
                return this.mDTD.getGeneralEntityList();
            }
            if (name.equals(STAX_PROP_NOTATIONS)) {
                return this.mDTD.getNotationList();
            }
        }
        return super.getProperty(name);
    }

    public DTDSubset getDTD() {
        return this.mDTD;
    }

    protected void finishDTD(boolean copyContents) throws IOException, XMLStreamException {
        DTDSubset extSubset;
        if (!this.hasConfigFlags(16)) {
            super.finishDTD(copyContents);
            return;
        }
        if (!copyContents) {
            ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr);
        }
        char c = this.getNextChar(" in DOCTYPE declaration");
        DTDSubset intSubset = null;
        if (c == '[') {
            intSubset = this.mConfig.getDtdReader().readInternalSubset(this, this.mInput, this.mConfig);
            c = this.getNextCharAfterWS(" in internal DTD subset");
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, "; expected '>' to finish DOCTYPE declaration.");
        }
        if (copyContents) {
            ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr);
        }
        DTDSubset dTDSubset = extSubset = this.mDtdPublicId != null || this.mDtdSystemId != null ? this.findDtdExtSubset(this.mDtdPublicId, this.mDtdSystemId, intSubset) : null;
        DTDSubset combo = intSubset == null ? extSubset : (extSubset == null ? intSubset : intSubset.combineWithExternalSubset(extSubset, this.mConfig.getXMLReporter()));
        this.mDTD = combo;
        Map map = this.mGeneralEntities = combo == null ? null : combo.getGeneralEntityMap();
        if (this.hasConfigFlags(32)) {
            this.mElementStack.setElementSpecs(combo.getElementMap());
        }
    }

    private DTDSubset findDtdExtSubset(String pubId, String sysId, DTDSubset intSubset) throws IOException, XMLStreamException {
        WstxInputResolver res;
        WstxInputSource src;
        boolean cache = this.hasConfigFlags(16384);
        URL sysRef = null;
        DTDId dtdId = null;
        DTDSubset extSubset = null;
        if (cache) {
            int significantFlags = this.mConfigFlags & 0x301;
            if (pubId != null) {
                dtdId = DTDId.constructFromPublicId(pubId, significantFlags);
            } else {
                sysRef = this.resolveExtSubsetPath(sysId);
                dtdId = DTDId.constructFromSystemId(sysRef, significantFlags);
            }
            extSubset = this.mOwner.findCachedDTD(dtdId);
            if (extSubset != null && (intSubset == null || extSubset.isReusableWith(intSubset))) {
                return extSubset;
            }
        }
        if (sysId == null) {
            this.throwParseError("Can not resolve DTD with public id '" + this.mDtdPublicId + "'; missing system identifier.");
        }
        if (sysRef == null) {
            sysRef = this.resolveExtSubsetPath(sysId);
        }
        if ((src = (res = this.mConfig.getDtdResolver()) != null ? res.resolveReference(this.mInput, null, this.mDtdPublicId, this.mDtdSystemId, sysRef) : null) == null) {
            src = DefaultInputResolver.getInstance().resolveReference(this.mInput, null, this.mDtdPublicId, this.mDtdSystemId, sysRef);
        }
        extSubset = this.mConfig.getDtdReader().readExternalSubset(this, src, this.mConfig, intSubset);
        if (cache && extSubset.isCachable()) {
            this.mOwner.addCachedDTD(dtdId, extSubset);
        }
        return extSubset;
    }

    private URL resolveExtSubsetPath(String systemId) throws IOException {
        URL ctxt = this.mInput.getSource();
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(systemId);
        }
        return URLUtil.urlFromSystemId(systemId, ctxt);
    }

    protected void reportInvalidContent(int evtType) throws WstxException {
        switch (this.mVldContent) {
            case 0: {
                this.throwParseError(ErrorConsts.ERR_VLD_EMPTY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            case 1: {
                this.throwParseError(ErrorConsts.ERR_VLD_NON_MIXED, this.mElementStack.getTopElementDesc());
                break;
            }
            case 2: {
                this.throwParseError(ErrorConsts.ERR_VLD_ANY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            default: {
                this.throwParseError("Internal error: trying to report invalid content for " + evtType);
            }
        }
    }
}

