/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.DefaultXmlSymbolTable;
import com.ctc.wstx.stax.cfg.InputConfigFlags;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.dtd.DTDId;
import com.ctc.wstx.stax.dtd.DTDReaderProxy;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.dtd.MinimalDTDReaderProxy;
import com.ctc.wstx.stax.exc.WstxIOException;
import com.ctc.wstx.stax.io.BranchingReaderSource;
import com.ctc.wstx.stax.io.InputBootstrapper;
import com.ctc.wstx.stax.io.InputSourceFactory;
import com.ctc.wstx.stax.io.ReaderBootstrapper;
import com.ctc.wstx.stax.io.StreamBootstrapper;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.stream.BasicStreamReader;
import com.ctc.wstx.stax.stream.ReaderCreator;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class MinimalInputFactory
implements ReaderCreator,
InputConfigFlags {
    protected final boolean mIsMinimal;
    protected final ReaderConfig mConfig;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;
    static /* synthetic */ Class class$com$ctc$wstx$stax$MinimalInputFactory;

    public MinimalInputFactory() {
        this(MinimalDTDReaderProxy.getInstance(), true);
    }

    protected MinimalInputFactory(DTDReaderProxy dtdReader, boolean minimal) {
        this.mConfig = ReaderConfig.createJ2MEDefaults(this.mSymbols, dtdReader);
        this.mIsMinimal = minimal;
    }

    public static MinimalInputFactory newMinimalInstance() {
        return new MinimalInputFactory();
    }

    public DTDSubset findCachedDTD(DTDId id) {
        return null;
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = this.mSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createSR(null, StreamBootstrapper.getInstance(in, null, null, this.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        if (enc == null || enc.length() == 0) {
            return this.createXMLStreamReader(in);
        }
        try {
            return this.createSR(null, ReaderBootstrapper.getInstance(new InputStreamReader(in, enc), null, null, this.getInputBufferLength(), enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createXMLStreamReader(null, r);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createSR(source);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, StreamBootstrapper.getInstance(in, null, systemId, this.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, this.getInputBufferLength(), null));
    }

    public Object getProperty(String name) {
        int id = this.mConfig.getPropertyId(name);
        if (id == 7) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
        return this.mConfig.getProperty(id);
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String propName, Object value) {
        int id = this.mConfig.getPropertyId(propName);
        if (id == 7) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
        this.mConfig.setProperty(propName, id, value);
    }

    public boolean willCoalesceText() {
        return this.mConfig.willCoalesceText();
    }

    public boolean willSupportNamespaces() {
        return this.mConfig.willSupportNamespaces();
    }

    public boolean willReplaceEntityRefs() {
        return this.mConfig.willReplaceEntityRefs();
    }

    public boolean willSupportExternalEntities() {
        return this.mConfig.willSupportExternalEntities();
    }

    public boolean willSupportDTDs() {
        return this.mConfig.willSupportDTDs();
    }

    public boolean willValidateWithDTD() {
        return this.mConfig.willValidateWithDTD();
    }

    public boolean willNormalizeLFs() {
        return this.mConfig.willNormalizeLFs();
    }

    public boolean willNormalizeAttrValues() {
        return this.mConfig.willNormalizeAttrValues();
    }

    public boolean willInternNsURIs() {
        return this.mConfig.willInternNsURIs();
    }

    public boolean willReportAllTextAsCharacters() {
        return this.mConfig.willReportAllTextAsCharacters();
    }

    public boolean willReportPrologWhitespace() {
        return this.mConfig.willReportPrologWhitespace();
    }

    public boolean willCacheDTDs() {
        return this.mConfig.willCacheDTDs();
    }

    public boolean willParseLazily() {
        return this.mConfig.willParseLazily();
    }

    public int getInputBufferLength() {
        return this.mConfig.getInputBufferLength();
    }

    public int getTextBufferLength() {
        return this.mConfig.getTextBufferLength();
    }

    public int getShortestReportedTextSegment() {
        return this.mConfig.getShortestReportedTextSegment();
    }

    public Map getCustomInternalEntities() {
        return this.mConfig.getCustomInternalEntities();
    }

    public URL getBaseURL() {
        return this.mConfig.getBaseURL();
    }

    public WstxInputResolver getDtdResolver() {
        return null;
    }

    public WstxInputResolver getEntityResolver() {
        return this.mConfig.getEntityResolver();
    }

    public void doCoalesceText(boolean state) {
        this.mConfig.doCoalesceText(state);
    }

    public void doSupportNamespaces(boolean state) {
        this.mConfig.doSupportNamespaces(state);
    }

    public void doReplaceEntityRefs(boolean state) {
        this.mConfig.doReplaceEntityRefs(state);
    }

    public void doSupportExternalEntities(boolean state) {
        this.mConfig.doSupportExternalEntities(state);
    }

    public void doSupportDTDs(boolean state) {
        if (state && this.mIsMinimal) {
            this.throwUnsupported("doSupportDTDs(true)");
        }
        this.mConfig.doSupportDTDs(state);
    }

    public void doValidateWithDTD(boolean state) {
        if (state && this.mIsMinimal) {
            this.throwUnsupported("doValidateWithDTD(true)");
        }
        this.mConfig.doValidateWithDTD(state);
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public void doNormalizeLFs(boolean state) {
        this.mConfig.doNormalizeLFs(state);
    }

    public void doNormalizeAttrValues(boolean state) {
        this.mConfig.doNormalizeAttrValues(state);
    }

    public void doInternNsURIs(boolean state) {
        this.mConfig.doInternNsURIs(state);
    }

    public void doReportPrologWhitespace(boolean state) {
        this.mConfig.doReportPrologWhitespace(state);
    }

    public void doCacheDTDs(boolean state) {
        this.mConfig.doCacheDTDs(state);
    }

    public void doParseLazily(boolean state) {
        this.mConfig.doParseLazily(state);
    }

    public void doReportAllTextAsCharacters(boolean state) {
        this.mConfig.doReportAllTextAsCharacters(state);
    }

    public void setInputBufferLength(int value) {
        this.mConfig.setInputBufferLength(value);
    }

    public void setTextBufferLength(int value) {
        this.mConfig.setTextBufferLength(value);
    }

    public void setShortestReportedTextSegment(int value) {
        this.mConfig.setShortestReportedTextSegment(value);
    }

    public void setBaseURL(URL baseURL) {
        this.mConfig.setBaseURL(baseURL);
    }

    public void setCustomInternalEntities(Map in) {
        this.mConfig.setCustomInternalEntities(in);
    }

    public void setDtdResolver(WstxInputResolver r) {
        if (r != null && this.mIsMinimal) {
            this.throwUnsupported("setDtdResolver(...)");
        }
        this.mConfig.setDtdResolver(r);
    }

    public void setEntityResolver(WstxInputResolver r) {
        this.mConfig.setEntityResolver(r);
    }

    public void configureForMaxConformance() {
        this.mConfig.configureForMaxConformance();
    }

    public void configureForMaxConvenience() {
        this.mConfig.configureForMaxConvenience();
    }

    public void configureForMaxSpeed() {
        this.mConfig.configureForMaxSpeed();
    }

    public void configureForMinMemUsage() {
        this.mConfig.configureForMinMemUsage();
    }

    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    private XMLStreamReader createSR(String systemId, InputBootstrapper bs) throws XMLStreamException {
        Reader r;
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        try {
            r = bs.bootstrapInput(true, this.getXMLReporter());
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        BranchingReaderSource input = InputSourceFactory.constructBranchingSource(null, null, bs, null, systemId, src, r, false, cfg.getInputBufferLength());
        try {
            return BasicStreamReader.createBasicStreamReader(input, this, cfg, bs);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private XMLStreamReader createSR(Source src) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader nor input stream was set.");
                }
                bs = StreamBootstrapper.getInstance(in, ss.getPublicId(), ss.getSystemId(), this.getInputBufferLength());
            } else {
                bs = ReaderBootstrapper.getInstance(r, ss.getPublicId(), ss.getSystemId(), this.getInputBufferLength(), null);
            }
            return this.createSR(src.getSystemId(), bs);
        }
        if (src instanceof SAXSource) {
            SAXSource sr = (SAXSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a SAXSource -- not (yet) implemented.");
        }
        if (src instanceof DOMSource) {
            DOMSource sr = (DOMSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    private void throwUnsupported(String msg) {
        throw new IllegalArgumentException("MinimalInputFactory has no DTD support: can not call " + msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java " + (class$com$ctc$wstx$stax$MinimalInputFactory == null ? (class$com$ctc$wstx$stax$MinimalInputFactory = MinimalInputFactory.class$("com.ctc.wstx.stax.MinimalInputFactory")) : class$com$ctc$wstx$stax$MinimalInputFactory) + " [input file]");
            System.exit(1);
        }
        MinimalInputFactory f = new MinimalInputFactory();
        System.out.println("Creating J2ME stream reader for file '" + args[0] + "'.");
        XMLStreamReader r = f.createXMLStreamReader(new FileInputStream(args[0]));
        r.close();
        System.out.println("Reader created and closed ok, exiting.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

