/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import tools.jackson.core.FormatFeature;

public enum YAMLWriteFeature implements FormatFeature
{
    WRITE_DOC_START_MARKER(true),
    USE_NATIVE_OBJECT_ID(true),
    USE_NATIVE_TYPE_ID(true),
    CANONICAL_OUTPUT(false),
    SPLIT_LINES(true),
    MINIMIZE_QUOTES(false),
    ALWAYS_QUOTE_NUMBERS_AS_STRINGS(false),
    LITERAL_BLOCK_STYLE(false),
    INDENT_ARRAYS(false),
    INDENT_ARRAYS_WITH_INDICATOR(false),
    ALLOW_LONG_KEYS(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (YAMLWriteFeature f : YAMLWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private YAMLWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    public int getMask() {
        return this._mask;
    }
}

