/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Iterator;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.NameTransformer;

public abstract class ValueSerializer<T>
implements JsonFormatVisitable {
    public void resolve(SerializationContext ctxt) {
    }

    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        return this;
    }

    public ValueSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this;
    }

    public ValueSerializer<T> replaceDelegatee(ValueSerializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public ValueSerializer<?> withFilterId(Object filterId) {
        return this;
    }

    public ValueSerializer<?> withIgnoredProperties(Set<String> ignoredProperties) {
        return this;
    }

    public ValueSerializer<?> withFormatOverrides(SerializationConfig config, JsonFormat.Value formatOverrides) {
        if (formatOverrides.getShape() == JsonFormat.Shape.ANY) {
            return this;
        }
        return null;
    }

    public abstract void serialize(T var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    public void serializeWithType(T value, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        Class<?> clz = this.handledType();
        if (clz == null) {
            clz = value.getClass();
        }
        ctxt.reportBadDefinition(clz, String.format("Type id handling not implemented for type %s (by serializer of type %s)", clz.getName(), this.getClass().getName()));
    }

    public Class<?> handledType() {
        return Object.class;
    }

    public boolean usesObjectId() {
        return false;
    }

    public boolean isUnwrappingSerializer() {
        return false;
    }

    public ValueSerializer<?> getDelegatee() {
        return null;
    }

    public Iterator<PropertyWriter> properties() {
        return ClassUtil.emptyIterator();
    }

    public boolean isEmpty(SerializationContext ctxt, T value) {
        return value == null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) {
        visitor.expectAnyFormat(type);
    }

    public static abstract class None
    extends ValueSerializer<Object> {
    }
}

