/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation.type;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import com.rd.animation.controller.ValueController;
import com.rd.animation.data.type.ThinWormAnimationValue;
import com.rd.animation.type.WormAnimation;

public class ThinWormAnimation
extends WormAnimation {
    private ThinWormAnimationValue value = new ThinWormAnimationValue();

    public ThinWormAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    public ThinWormAnimation duration(long duration) {
        super.duration(duration);
        return this;
    }

    @Override
    public WormAnimation with(int coordinateStart, int coordinateEnd, int radius, boolean isRightSide) {
        if (this.hasChanges(coordinateStart, coordinateEnd, radius, isRightSide)) {
            this.animator = this.createAnimator();
            this.coordinateStart = coordinateStart;
            this.coordinateEnd = coordinateEnd;
            this.radius = radius;
            this.isRightSide = isRightSide;
            int height = radius * 2;
            this.rectLeftEdge = coordinateStart - radius;
            this.rectRightEdge = coordinateStart + radius;
            this.value.setRectStart(this.rectLeftEdge);
            this.value.setRectEnd(this.rectRightEdge);
            this.value.setHeight(height);
            WormAnimation.RectValues rec = this.createRectValues(isRightSide);
            long sizeDuration = (long)((double)this.animationDuration * 0.8);
            long reverseDelay = (long)((double)this.animationDuration * 0.2);
            long heightDuration = (long)((double)this.animationDuration * 0.5);
            long reverseHeightDelay = (long)((double)this.animationDuration * 0.5);
            ValueAnimator straightAnimator = this.createWormAnimator(rec.fromX, rec.toX, sizeDuration, false, this.value);
            ValueAnimator reverseAnimator = this.createWormAnimator(rec.reverseFromX, rec.reverseToX, sizeDuration, true, this.value);
            reverseAnimator.setStartDelay(reverseDelay);
            ValueAnimator straightHeightAnimator = this.createHeightAnimator(height, radius, heightDuration);
            ValueAnimator reverseHeightAnimator = this.createHeightAnimator(radius, height, heightDuration);
            reverseHeightAnimator.setStartDelay(reverseHeightDelay);
            ((AnimatorSet)this.animator).playTogether(new Animator[]{straightAnimator, reverseAnimator, straightHeightAnimator, reverseHeightAnimator});
        }
        return this;
    }

    private ValueAnimator createHeightAnimator(int fromHeight, int toHeight, long duration) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromHeight, toHeight});
        anim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim.setDuration(duration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ThinWormAnimation.this.onAnimateUpdated(animation);
            }
        });
        return anim;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        this.value.setHeight((Integer)animation.getAnimatedValue());
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    @Override
    public ThinWormAnimation progress(float progress) {
        if (this.animator != null) {
            long progressDuration = (long)(progress * (float)this.animationDuration);
            int size = ((AnimatorSet)this.animator).getChildAnimations().size();
            for (int i = 0; i < size; ++i) {
                long duration;
                ValueAnimator anim = (ValueAnimator)((AnimatorSet)this.animator).getChildAnimations().get(i);
                long setDuration = progressDuration - anim.getStartDelay();
                if (setDuration > (duration = anim.getDuration())) {
                    setDuration = duration;
                } else if (setDuration < 0L) {
                    setDuration = 0L;
                }
                if (i == size - 1 && setDuration <= 0L || anim.getValues() == null || anim.getValues().length <= 0) continue;
                anim.setCurrentPlayTime(setDuration);
            }
        }
        return this;
    }
}

