/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationWrapper;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendSearchOperation
extends SearchOperationWrapper
implements PreOperationSearchOperation,
PostOperationSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Backend backend;
    private boolean processSearch;
    private ClientConnection clientConnection;
    private DN baseDN;
    private PersistentSearch persistentSearch;
    private SearchFilter filter;

    public LocalBackendSearchOperation(SearchOperation search) {
        super(search);
        LocalBackendWorkflowElement.attachLocalOperation(search, this);
    }

    void processLocalSearch(Backend backend) throws CanceledOperationException {
        PluginResult.PostOperation postOpResult;
        PluginConfigManager pluginConfigManager;
        boolean executePostOpPlugins;
        block21: {
            executePostOpPlugins = false;
            this.backend = backend;
            this.clientConnection = this.getClientConnection();
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            this.processSearch = true;
            this.checkIfCanceled(false);
            this.baseDN = this.getBaseDN();
            this.filter = this.getFilter();
            if (this.baseDN != null && this.filter != null) {
                try {
                    this.handleRequestControls();
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    this.setResponseData(de);
                    break block21;
                }
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                    this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    this.appendErrorMessage(CoreMessages.ERR_SEARCH_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.baseDN)));
                } else {
                    this.checkIfCanceled(false);
                    executePostOpPlugins = true;
                    PluginResult.PreOperation preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(this);
                    if (!preOpResult.continueProcessing()) {
                        this.setResultCode(preOpResult.getResultCode());
                        this.appendErrorMessage(preOpResult.getErrorMessage());
                        this.setMatchedDN(preOpResult.getMatchedDN());
                        this.setReferralURLs(preOpResult.getReferralURLs());
                    } else {
                        this.checkIfCanceled(false);
                        if (backend == null) {
                            this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                            this.appendErrorMessage(CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.baseDN)));
                        } else {
                            this.setResultCode(ResultCode.SUCCESS);
                            if (this.persistentSearch != null) {
                                DirectoryServer.registerPersistentSearch(this.persistentSearch);
                                this.setSendResponse(false);
                            }
                            try {
                                if (this.processSearch) {
                                    backend.search(this);
                                }
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.VERBOSE, de);
                                }
                                this.setResponseData(de);
                                if (this.persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                    this.setSendResponse(true);
                                }
                            }
                            catch (CanceledOperationException coe) {
                                if (this.persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                    this.setSendResponse(true);
                                }
                                throw coe;
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                this.setResultCode(DirectoryServer.getServerErrorResultCode());
                                this.appendErrorMessage(CoreMessages.ERR_SEARCH_BACKEND_EXCEPTION.get(StaticUtils.getExceptionMessage(e)));
                                if (this.persistentSearch == null) break block21;
                                DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                this.setSendResponse(true);
                            }
                        }
                    }
                }
            }
        }
        this.checkIfCanceled(false);
        if (executePostOpPlugins && !(postOpResult = pluginConfigManager.invokePostOperationSearchPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
    }

    private void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.baseDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl;
                    if (c instanceof LDAPAssertionRequestControl) {
                        assertControl = (LDAPAssertionRequestControl)c;
                    } else {
                        try {
                            assertControl = LDAPAssertionRequestControl.decodeControl(c);
                            requestControls.set(i, assertControl);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject(), le);
                        }
                    }
                    try {
                        Entry entry;
                        SearchFilter assertionFilter = assertControl.getSearchFilter();
                        try {
                            entry = DirectoryServer.getEntry(this.baseDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_GET_ENTRY_FOR_ASSERTION.get(de.getMessageObject()));
                        }
                        if (entry == null) {
                            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, CoreMessages.ERR_SEARCH_NO_SUCH_ENTRY_FOR_ASSERTION.get());
                        }
                        if (assertionFilter.matchesEntry(entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_SEARCH_ASSERTION_FAILED.get());
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()), de);
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV1Control) {
                        proxyControl = (ProxiedAuthV1Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV1Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject(), le);
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV2Control) {
                        proxyControl = (ProxiedAuthV2Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV2Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject(), le);
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.3")) {
                    PersistentSearchControl psearchControl;
                    if (c instanceof PersistentSearchControl) {
                        psearchControl = (PersistentSearchControl)c;
                    } else {
                        try {
                            psearchControl = PersistentSearchControl.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject(), le);
                        }
                    }
                    this.persistentSearch = new PersistentSearch(this, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                    this.setPersistentSearch(this.persistentSearch);
                    if (!psearchControl.getChangesOnly()) continue;
                    this.processSearch = false;
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                    this.setReturnLDAPSubentries(true);
                    continue;
                }
                if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                    if (c instanceof MatchedValuesControl) {
                        this.setMatchedValuesControl((MatchedValuesControl)c);
                        continue;
                    }
                    try {
                        MatchedValuesControl matchedValuesControl = MatchedValuesControl.decodeControl(c);
                        this.setMatchedValuesControl(matchedValuesControl);
                        continue;
                    }
                    catch (LDAPException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject(), le);
                    }
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                    this.setIncludeUsableControl(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.17")) {
                    this.setRealAttributesOnly(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.19")) {
                    this.setVirtualAttributesOnly(true);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.2") && DirectoryServer.isSupportedControl("1.3.6.1.4.1.42.2.27.9.5.2") || !c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_SEARCH_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }
}

