/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MenuResult<T> {
    private final Type type;
    private final Collection<T> values;

    public static <T> MenuResult<T> again() {
        return new MenuResult(Type.AGAIN, Collections.emptyList());
    }

    public static <T> MenuResult<T> cancel() {
        return new MenuResult(Type.CANCEL, Collections.emptyList());
    }

    public static <T> MenuResult<T> quit() {
        return new MenuResult(Type.QUIT, Collections.emptyList());
    }

    public static <T> MenuResult<T> success() {
        return MenuResult.success(Collections.emptySet());
    }

    public static <T> MenuResult<T> success(Collection<T> values) {
        return new MenuResult<T>(Type.SUCCESS, new ArrayList<T>(values));
    }

    public static <T> MenuResult<T> success(T value) {
        return MenuResult.success(Collections.singleton(value));
    }

    private MenuResult(Type type, Collection<T> values) {
        this.type = type;
        this.values = values;
    }

    public T getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    public Collection<T> getValues() {
        return new ArrayList<T>(this.values);
    }

    public boolean isAgain() {
        return this.type == Type.AGAIN;
    }

    public boolean isCancel() {
        return this.type == Type.CANCEL;
    }

    public boolean isQuit() {
        return this.type == Type.QUIT;
    }

    public boolean isSuccess() {
        return this.type == Type.SUCCESS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        AGAIN,
        CANCEL,
        QUIT,
        SUCCESS;

    }
}

