/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public abstract class RawModification {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawModification create(ModificationType modificationType, RawAttribute attribute) {
        return new LDAPModification(modificationType, attribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, String attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, ByteString attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, List<ByteString> attributeValues) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValues);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public abstract ModificationType getModificationType();

    public abstract void setModificationType(ModificationType var1);

    public abstract RawAttribute getAttribute();

    public abstract void setAttribute(RawAttribute var1);

    public final ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(this.getModificationType().intValue()));
        elements.add(this.getAttribute().encode());
        return new ASN1Sequence(elements);
    }

    public static LDAPModification decode(ASN1Element element) throws LDAPException {
        LDAPAttribute attribute;
        ModificationType modificationType;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            switch (elements.get(0).decodeAsEnumerated().intValue()) {
                case 0: {
                    modificationType = ModificationType.ADD;
                    break;
                }
                case 1: {
                    modificationType = ModificationType.DELETE;
                    break;
                }
                case 2: {
                    modificationType = ModificationType.REPLACE;
                    break;
                }
                case 3: {
                    modificationType = ModificationType.INCREMENT;
                    break;
                }
                default: {
                    int intValue = elements.get(0).decodeAsEnumerated().intValue();
                    Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_MOD_TYPE.get(intValue);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_MOD_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attribute = RawAttribute.decode(elements.get(1));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_ATTR.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPModification(modificationType, attribute);
    }

    public abstract Modification toModification() throws LDAPException;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

