/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public class Control {
    private ASN1OctetString value;
    private boolean isCritical;
    private String oid;

    public Control(String oid, boolean isCritical) {
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = null;
    }

    public Control(String oid, boolean isCritical, ASN1OctetString value) {
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = value;
    }

    public final String getOID() {
        return this.oid;
    }

    public final void setOID(String oid) {
        this.oid = oid;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final void setCritical(boolean isCritical) {
        this.isCritical = isCritical;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final void setValue(ASN1OctetString value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("Control(oid=");
        buffer.append(this.oid);
        buffer.append(",isCritical=");
        buffer.append(this.isCritical);
        if (this.value != null) {
            buffer.append(",value=");
            this.value.toString(buffer);
        }
        buffer.append(")");
    }
}

