/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AuthenticationInfo {
    private ByteString simplePassword;
    private boolean isAuthenticated;
    private boolean isRoot;
    private boolean mustChangePassword;
    private Entry authenticationEntry;
    private Entry authorizationEntry;
    private Set<AuthenticationType> authenticationTypes;
    private Set<String> saslMechanisms;

    public AuthenticationInfo() {
        this.isAuthenticated = false;
        this.isRoot = false;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(0);
        this.authenticationEntry = null;
        this.authorizationEntry = null;
        this.saslMechanisms = new HashSet<String>(0);
    }

    public AuthenticationInfo(Entry authenticationEntry, boolean isRoot) {
        this.authenticationEntry = authenticationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = authenticationEntry != null;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authorizationEntry = authenticationEntry;
        this.saslMechanisms = new HashSet<String>(0);
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.INTERNAL);
    }

    public AuthenticationInfo(Entry authenticationEntry, ByteString simplePassword, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, simplePassword);
        this.authenticationEntry = authenticationEntry;
        this.simplePassword = simplePassword;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationEntry = authenticationEntry;
        this.saslMechanisms = new HashSet<String>(0);
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SIMPLE);
    }

    public AuthenticationInfo(Entry authenticationEntry, String saslMechanism, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, saslMechanism);
        this.authenticationEntry = authenticationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationEntry = authenticationEntry;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SASL);
        this.saslMechanisms = new HashSet<String>(1);
        this.saslMechanisms.add(saslMechanism);
    }

    public AuthenticationInfo(Entry authenticationEntry, Entry authorizationEntry, String saslMechanism, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, saslMechanism);
        this.authenticationEntry = authenticationEntry;
        this.authorizationEntry = authorizationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SASL);
        this.saslMechanisms = new HashSet<String>(1);
        this.saslMechanisms.add(saslMechanism);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setUnauthenticated() {
        this.isAuthenticated = false;
        this.isRoot = false;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationEntry = null;
        this.authorizationEntry = null;
        this.authenticationTypes.clear();
        this.saslMechanisms.clear();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean mustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    public boolean hasAuthenticationType(AuthenticationType authenticationType) {
        return this.authenticationTypes.contains((Object)authenticationType);
    }

    public boolean hasAnyAuthenticationType(Collection<AuthenticationType> types) {
        for (AuthenticationType t : types) {
            if (!this.authenticationTypes.contains((Object)t)) continue;
            return true;
        }
        return false;
    }

    public Set<AuthenticationType> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public void addAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationTypes.add(authenticationType);
    }

    public Entry getAuthenticationEntry() {
        return this.authenticationEntry;
    }

    public DN getAuthenticationDN() {
        if (this.authenticationEntry == null) {
            return null;
        }
        return this.authenticationEntry.getDN();
    }

    public Entry getAuthorizationEntry() {
        return this.authorizationEntry;
    }

    public DN getAuthorizationDN() {
        if (this.authorizationEntry == null) {
            return null;
        }
        return this.authorizationEntry.getDN();
    }

    public ByteString getSimplePassword() {
        return this.simplePassword;
    }

    public boolean hasSASLMechanism(String saslMechanism) {
        return this.saslMechanisms.contains(saslMechanism);
    }

    public boolean hasAnySASLMechanism(Collection<String> mechanisms) {
        for (String s : mechanisms) {
            if (!this.saslMechanisms.contains(s)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSASLMechanisms() {
        return this.saslMechanisms;
    }

    public void addSASLMechanism(String saslMechanism) {
        this.saslMechanisms.add(saslMechanism);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append("AuthenticationInfo(isAuthenticated=");
        buffer.append(this.isAuthenticated);
        buffer.append(",isRoot=");
        buffer.append(this.isRoot);
        buffer.append(",mustChangePassword=");
        buffer.append(this.mustChangePassword);
        buffer.append(",authenticationDN=\"");
        if (this.authenticationEntry != null) {
            this.authenticationEntry.getDN().toString(buffer);
        }
        if (this.authorizationEntry == null) {
            buffer.append("\",authorizationDN=\"\"");
        } else {
            buffer.append("\",authorizationDN=\"");
            this.authorizationEntry.getDN().toString(buffer);
            buffer.append("\"");
        }
        if (!this.authenticationTypes.isEmpty()) {
            iterator = this.authenticationTypes.iterator();
            AuthenticationType authType = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(",authTypes={");
                buffer.append((Object)authType);
                while (iterator.hasNext()) {
                    buffer.append(",");
                    buffer.append(iterator.next());
                }
                buffer.append("}");
            } else {
                buffer.append(",authType=");
                buffer.append((Object)authType);
            }
        }
        if (!this.saslMechanisms.isEmpty()) {
            iterator = this.saslMechanisms.iterator();
            String mech = (String)iterator.next();
            if (iterator.hasNext()) {
                buffer.append(",saslMechanisms={");
                buffer.append(mech);
                while (iterator.hasNext()) {
                    buffer.append(",");
                    buffer.append((String)iterator.next());
                }
                buffer.append("}");
            } else {
                buffer.append(",saslMechanism=");
                buffer.append(mech);
            }
        }
        buffer.append(")");
    }

    public AuthenticationInfo duplicate(Entry newAuthenticationEntry, Entry newAuthorizationEntry) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.simplePassword = this.simplePassword;
        authInfo.isAuthenticated = this.isAuthenticated;
        authInfo.isRoot = this.isRoot;
        authInfo.mustChangePassword = this.mustChangePassword;
        authInfo.authenticationEntry = newAuthenticationEntry;
        authInfo.authorizationEntry = newAuthorizationEntry;
        authInfo.authenticationTypes.addAll(this.authenticationTypes);
        authInfo.saslMechanisms.addAll(this.saslMechanisms);
        return authInfo;
    }
}

