/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectOption;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.ContainsCondition;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.PropertyEditorModification;
import org.opends.server.tools.dsconfig.PropertyValueEditor;
import org.opends.server.tools.dsconfig.SetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.HelpCallback;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.cli.ValidationCallback;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateSubCommandHandler<C extends ConfigurationClient, S extends Configuration>
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private static final Character OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
    private static final String OPTION_DSCFG_LONG_REMOVE = "remove";
    private static final String OPTION_DSCFG_LONG_RESET = "reset";
    private final List<StringArgument> namingArgs;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertySetArgument;
    private final RelationDefinition<C, S> relation;
    private final SubCommand subCommand;
    private final StringArgument typeArgument;
    private final SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> types;
    private final String typeUsage;

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(parser, p, r, r.getNamingPropertyDefinition(), p.child(r, "DUMMY"));
    }

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(parser, p, r, null, p.child(r));
    }

    public static <C extends ConfigurationClient, S extends Configuration> MenuResult<String> createManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> parent, InstantiableRelationDefinition<C, S> rd) throws ClientException, CLIException {
        return CreateSubCommandHandler.createManagedObject(app, context, parent, rd, null);
    }

    private static <C extends ConfigurationClient, S extends Configuration> MenuResult<String> createManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> parent, InstantiableRelationDefinition<C, S> rd, SubCommandHandler handler) throws ClientException, CLIException {
        AbstractManagedObjectDefinition d = rd.getChildDefinition();
        MenuResult result = CreateSubCommandHandler.getTypeInteractively(app, d);
        if (!result.isSuccess()) {
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            return MenuResult.quit();
        }
        ManagedObjectDefinition mod = result.getValue();
        LinkedList<DefaultBehaviorException> exceptions = new LinkedList<DefaultBehaviorException>();
        app.println();
        app.println();
        ManagedObject<C> mo = CreateSubCommandHandler.createChildInteractively(app, parent, rd, mod, exceptions);
        MenuResult<Void> result2 = CreateSubCommandHandler.commitManagedObject(app, context, mo, handler);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        return MenuResult.success(mo.getManagedObjectPath().getName());
    }

    /*
     * Unable to fully structure code
     */
    private static MenuResult<Void> checkReferences(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException, CLIException {
        d = mo.getManagedObjectDefinition();
        ufn = d.getUserFriendlyName();
        try {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                if (!(pd instanceof AggregationPropertyDefinition) || !(apd = (AggregationPropertyDefinition)AggregationPropertyDefinition.class.cast(pd)).getTargetNeedsEnablingCondition().evaluate(context, mo)) continue;
                for (String name : mo.getPropertyValues(apd)) {
                    path = apd.getChildPath(name);
                    rufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    try {
                        ref = context.getManagedObject(path);
                    }
                    catch (DefinitionDecodingException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(rufn, rufn, rufn);
                        throw new ClientException(80, msg);
                    }
                    catch (ManagedObjectDecodingException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(rufn);
                        throw new ClientException(80, msg, e);
                    }
                    catch (ManagedObjectNotFoundException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(rufn);
                        throw new ClientException(32, msg);
                    }
                    condition = apd.getTargetIsEnabledCondition();
                    while (!condition.evaluate(context, ref)) {
                        isBadReference = true;
                        if (condition instanceof ContainsCondition) {
                            cvc = (ContainsCondition)condition;
                            app.println();
                            if (app.confirmAction(DSConfigMessages.INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT.get(rufn, name, ufn), true)) {
                                cvc.setPropertyValue(ref);
                                try {
                                    ref.commit();
                                    isBadReference = false;
                                }
                                catch (MissingMandatoryPropertiesException e) {
                                    app.println();
                                    ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                                    app.println();
                                    if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT.get(rufn), true)) ** GOTO lbl68
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl68
                                    isBadReference = false;
                                }
                                catch (ConcurrentModificationException e) {
                                    msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get(ufn);
                                    throw new ClientException(19, msg);
                                }
                                catch (OperationRejectedException e) {
                                    app.println();
                                    ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                                    app.println();
                                    if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT.get(rufn), true)) ** GOTO lbl68
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl68
                                    isBadReference = false;
                                }
                                catch (ManagedObjectAlreadyExistsException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                        } else {
                            app.println();
                            if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_TO_ENABLE.get(rufn, name, ufn), true)) {
                                result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                if (result.isQuit()) {
                                    return result;
                                }
                                if (result.isSuccess()) {
                                    isBadReference = false;
                                }
                            }
                        }
lbl68:
                        // 13 sources

                        if (!isBadReference) continue;
                        app.println();
                        app.println(DSConfigMessages.ERR_SET_REFERENCED_COMPONENT_DISABLED.get(ufn, rufn));
                        app.println();
                        if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) {
                            return MenuResult.again();
                        }
                        return MenuResult.cancel();
                    }
                }
            }
        }
        catch (AuthorizationException e) {
            msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (CommunicationException e) {
            msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get(ufn, e.getMessage());
            throw new ClientException(80, msg);
        }
        return MenuResult.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MenuResult<Void> commitManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException, CLIException {
        ManagedObjectDefinition<?, Configuration> d = mo.getManagedObjectDefinition();
        Message ufn = d.getUserFriendlyName();
        while (true) {
            Message msg;
            PropertyValueEditor editor = new PropertyValueEditor(app, context);
            if (app.isInteractive()) {
                TreeSet properties = new TreeSet();
                for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                    if (pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED)) continue;
                    properties.add(pd);
                }
                MenuResult<Void> result = editor.edit(mo, properties, false);
                if (result.isSuccess() && (result = CreateSubCommandHandler.checkReferences(app, context, mo, handler)).isAgain()) continue;
                if (result.isQuit()) {
                    if (app.isMenuDrivenMode()) return MenuResult.quit();
                    Message msg2 = DSConfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get(ufn);
                    app.printVerboseMessage(msg2);
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
            }
            try {
                mo.commit();
                app.println();
                Message msg3 = DSConfigMessages.INFO_DSCFG_CONFIRM_CREATE_SUCCESS.get(ufn);
                app.printVerboseMessage(msg3);
                for (PropertyEditorModification mod : editor.getModifications()) {
                    try {
                        Argument arg = CreateSubCommandHandler.createArgument(mod);
                        handler.getCommandBuilder().addArgument(arg);
                    }
                    catch (ArgumentException ae) {
                        throw new RuntimeException("Unexpected error generating the command builder: " + ae, ae);
                    }
                }
                handler.setCommandBuilderUseful(true);
                return MenuResult.success();
            }
            catch (MissingMandatoryPropertiesException e) {
                if (!app.isInteractive()) throw new ClientException(19, e.getMessageObject(), e);
                app.println();
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                app.println();
                if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) continue;
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (ConcurrentModificationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (OperationRejectedException e) {
                if (!app.isInteractive()) throw new ClientException(19, e.getMessageObject(), e);
                app.println();
                ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                app.println();
                if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) return MenuResult.cancel();
                continue;
            }
            catch (CommunicationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get(ufn, e.getMessage());
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectAlreadyExistsException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_MOAEE.get(ufn);
                throw new ClientException(68, msg);
            }
            break;
        }
    }

    private static <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> createChildInteractively(ConsoleApplication app, final ManagedObject<?> parent, final InstantiableRelationDefinition<C, S> irelation, final ManagedObjectDefinition<? extends C, ? extends S> d, final List<DefaultBehaviorException> exceptions) throws CLIException {
        ValidationCallback validator = new ValidationCallback<ManagedObject<? extends C>>(){

            @Override
            public ManagedObject<? extends C> validate(ConsoleApplication app, String input) throws CLIException {
                ManagedObject child;
                try {
                    child = parent.createChild(irelation, d, input, exceptions);
                }
                catch (IllegalManagedObjectNameException e) {
                    CLIException ae = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                    app.println();
                    app.println(ae.getMessageObject());
                    app.println();
                    return null;
                }
                try {
                    parent.getChild(irelation, input);
                }
                catch (AuthorizationException e) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get(irelation.getUserFriendlyName());
                    throw new CLIException(msg);
                }
                catch (ConcurrentModificationException e) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get(irelation.getUserFriendlyName());
                    throw new CLIException(msg);
                }
                catch (CommunicationException e) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get(irelation.getUserFriendlyName(), e.getMessage());
                    throw new CLIException(msg);
                }
                catch (DefinitionDecodingException e) {
                }
                catch (ManagedObjectDecodingException e) {
                }
                catch (ManagedObjectNotFoundException e) {
                    return child;
                }
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_NAME_ALREADY_EXISTS.get(irelation.getUserFriendlyName(), input);
                app.println();
                app.println(msg);
                app.println();
                return null;
            }
        };
        Message ufn = d.getUserFriendlyName();
        PropertyDefinition<?> pd = irelation.getNamingPropertyDefinition();
        if (pd != null) {
            app.println(DSConfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT_NAMING.get(ufn, pd.getName()));
            app.println();
            app.println(pd.getSynopsis(), 4);
            if (pd.getDescription() != null) {
                app.println();
                app.println(pd.getDescription(), 4);
            }
            PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
            TableBuilder builder = new TableBuilder();
            builder.startRow();
            builder.appendCell(DSConfigMessages.INFO_EDITOR_HEADING_SYNTAX.get());
            builder.appendCell(b.getUsage(pd));
            TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
            printer.setDisplayHeadings(false);
            printer.setIndentWidth(4);
            printer.setColumnWidth(1, 0);
            app.println();
            builder.print(printer);
            app.println();
            return (ManagedObject)app.readValidatedInput(DSConfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT_NAMING_CONT.get(ufn), validator);
        }
        return (ManagedObject)app.readValidatedInput(DSConfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT.get(ufn), validator);
    }

    private static <C extends ConfigurationClient, S extends Configuration> SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> getSubTypes(AbstractManagedObjectDefinition<C, S> d) {
        TreeMap<String, ManagedObjectDefinition<C, S>> map = new TreeMap<String, ManagedObjectDefinition<C, S>>();
        if (!d.hasOption(ManagedObjectOption.HIDDEN) && d instanceof ManagedObjectDefinition) {
            ManagedObjectDefinition mod = (ManagedObjectDefinition)d;
            if (CLIProfile.getInstance().isForCustomization(mod)) {
                map.put("custom", mod);
            } else {
                map.put("generic", mod);
            }
        }
        String suffix = "-" + d.getName();
        for (AbstractManagedObjectDefinition<C, S> c : d.getAllChildren()) {
            if (d.hasOption(ManagedObjectOption.HIDDEN) || !(c instanceof ManagedObjectDefinition)) continue;
            ManagedObjectDefinition mod = (ManagedObjectDefinition)c;
            String name = mod.getName();
            if (name.endsWith(suffix)) {
                name = name.substring(0, name.length() - suffix.length());
            }
            if (CLIProfile.getInstance().isForCustomization(mod)) {
                name = String.format("%s-%s", "custom", name);
            }
            map.put(name, mod);
        }
        return map;
    }

    private static <C extends ConfigurationClient, S extends Configuration> MenuResult<ManagedObjectDefinition<? extends C, ? extends S>> getTypeInteractively(ConsoleApplication app, AbstractManagedObjectDefinition<C, S> d) throws CLIException {
        Collection<ManagedObjectDefinition<C, S>> types = CreateSubCommandHandler.getSubTypes(d).values();
        if (types.size() == 1) {
            ManagedObjectDefinition<C, S> type = types.iterator().next();
            return MenuResult.success(type);
        }
        MenuBuilder<ManagedObjectDefinition<C, S>> builder = new MenuBuilder<ManagedObjectDefinition<C, S>>(app);
        Message msg = DSConfigMessages.INFO_DSCFG_CREATE_TYPE_PROMPT.get(d.getUserFriendlyName());
        builder.setMultipleColumnThreshold(8);
        builder.setPrompt(msg);
        for (ManagedObjectDefinition<C, S> mod : types) {
            if (!app.isAdvancedMode() && (mod.hasOption(ManagedObjectOption.ADVANCED) || CLIProfile.getInstance().isForCustomization(mod))) continue;
            Message option = mod.getUserFriendlyName();
            if (CLIProfile.getInstance().isForCustomization(mod)) {
                option = DSConfigMessages.INFO_DSCFG_CUSTOM_TYPE_OPTION.get(option);
            } else if (mod == d) {
                option = DSConfigMessages.INFO_DSCFG_GENERIC_TYPE_OPTION.get(option);
            }
            builder.addNumberedOption(option, MenuResult.success(mod), new Message[0]);
        }
        builder.addHelpOption(new TypeHelpCallback(d));
        if (app.isMenuDrivenMode()) {
            builder.addCancelOption(true);
        }
        builder.addQuitOption();
        return builder.toMenu().run();
    }

    private CreateSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<C, S> r, PropertyDefinition<?> pd, ManagedObjectPath<?, ?> c) throws ArgumentException {
        this.path = p;
        this.relation = r;
        this.namingPropertyDefinition = pd;
        String name = "create-" + r.getName();
        Message description = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_CREATE.get(r.getChildDefinition().getUserFriendlyPluralName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.types = CreateSubCommandHandler.getSubTypes(r.getChildDefinition());
        this.namingArgs = this.createNamingArgs(this.subCommand, c, true);
        this.propertySetArgument = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
        this.subCommand.addArgument(this.propertySetArgument);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String s : this.types.keySet()) {
            if (!isFirst) {
                builder.append(" | ");
            }
            builder.append(s);
            isFirst = false;
        }
        this.typeUsage = builder.toString();
        if (!this.types.containsKey("generic")) {
            this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, ToolMessages.INFO_TYPE_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_TYPE.get(r.getChildDefinition().getUserFriendlyName(), this.typeUsage));
        } else {
            this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, ToolMessages.INFO_TYPE_PLACEHOLDER.get(), "generic", null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_TYPE_DEFAULT.get(r.getChildDefinition().getUserFriendlyName(), "generic", this.typeUsage));
            if (this.types.size() == 1) {
                this.typeArgument.setHidden(true);
            }
        }
        this.subCommand.addArgument(this.typeArgument);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        block38: {
            if (this.typeArgument.isPresent()) ** GOTO lbl18
            if (!app.isInteractive()) ** GOTO lbl14
            app.println();
            app.println();
            result = CreateSubCommandHandler.getTypeInteractively(app, this.relation.getChildDefinition());
            if (result.isSuccess()) {
                d = result.getValue();
            } else {
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                if (!app.isMenuDrivenMode()) {
                    app.printVerboseMessage(DSConfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get(this.relation.getUserFriendlyName()));
                }
                return MenuResult.quit();
lbl14:
                // 1 sources

                if (this.typeArgument.getDefaultValue() != null) {
                    d = (ManagedObjectDefinition)this.types.get(this.typeArgument.getDefaultValue());
                } else {
                    throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(this.typeArgument);
lbl18:
                    // 1 sources

                    d = (ManagedObjectDefinition<C, S>)this.types.get(this.typeArgument.getValue());
                    if (d == null) {
                        throw ArgumentExceptionFactory.unknownSubType(this.relation, this.typeArgument.getValue(), this.typeUsage);
                    }
                }
            }
            ufn = d.getUserFriendlyName();
            names = this.getNamingArgValues(app, this.namingArgs);
            this.getCommandBuilder().clearArguments();
            this.setCommandBuilderUseful(false);
            this.updateCommandBuilderWithSubCommand();
            propertyArgs = this.propertySetArgument.getValues();
            provider = new MyPropertyProvider(d, this.namingPropertyDefinition, propertyArgs);
            context = factory.getManagementContext(app);
            try {
                result = this.getManagedObject(app, context, this.path, names);
            }
            catch (AuthorizationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (DefinitionDecodingException e) {
                pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(pufn, pufn, pufn);
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectDecodingException e) {
                pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(pufn);
                throw new ClientException(80, msg, e);
            }
            catch (CommunicationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
            catch (ConcurrentModificationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(pufn);
                throw new ClientException(32, msg);
            }
            if (result.isQuit()) {
                if (!app.isMenuDrivenMode()) {
                    msg = DSConfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get(ufn);
                    app.printVerboseMessage(msg);
                }
                return MenuResult.quit();
            }
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            parent = result.getValue();
            exceptions = new LinkedList<DefaultBehaviorException>();
            isNameProvidedInteractively = false;
            providedNamingArgName = null;
            if (!(this.relation instanceof InstantiableRelationDefinition)) break block38;
            irelation = (InstantiableRelationDefinition)this.relation;
            name = names.get(names.size() - 1);
            if (name != null) ** GOTO lbl76
            if (app.isInteractive()) {
                app.println();
                app.println();
                child = CreateSubCommandHandler.createChildInteractively(app, parent, irelation, d, exceptions);
                isNameProvidedInteractively = true;
                providedNamingArgName = CLIProfile.getInstance().getNamingArgument(irelation);
            } else {
                throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(this.namingArgs.get(names.size() - 1));
lbl76:
                // 1 sources

                try {
                    child = parent.createChild(irelation, d, name, exceptions);
                }
                catch (IllegalManagedObjectNameException e) {
                    throw ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                }
            }
        }
        orelation = (OptionalRelationDefinition)this.relation;
        child = parent.createChild(orelation, d, exceptions);
        for (PropertyDefinition<?> pd : provider.getProperties()) {
            this.setProperty(child, provider, pd);
        }
        result2 = CreateSubCommandHandler.commitManagedObject(app, context, child, this);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        if (this.typeArgument.hasValue()) {
            this.getCommandBuilder().addArgument(this.typeArgument);
        } else {
            arg = new StringArgument(this.typeArgument.getName(), CreateSubCommandHandler.OPTION_DSCFG_SHORT_TYPE, "type", false, false, true, ToolMessages.INFO_TYPE_PLACEHOLDER.get(), this.typeArgument.getDefaultValue(), this.typeArgument.getPropertyName(), this.typeArgument.getDescription());
            arg.addValue(this.getTypeName(d));
            this.getCommandBuilder().addArgument(arg);
        }
        if (this.propertySetArgument.hasValue()) {
            filteredArg = new StringArgument("set", CreateSubCommandHandler.OPTION_DSCFG_SHORT_SET, "set", false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
            for (String value : this.propertySetArgument.getValues()) {
                addValue = true;
                index = value.indexOf(58);
                if (index != -1) {
                    propName = value.substring(0, index);
                    for (Argument arg : this.getCommandBuilder().getArguments()) {
                        for (String value2 : arg.getValues()) {
                            prop2Name = arg.getName().equals("set") || arg.getName().equals("remove") ? ((index2 = value2.indexOf(58)) != -1 ? value2.substring(0, index2) : null) : (arg.getName().equals("reset") != false ? value2 : null);
                            if (prop2Name == null || !prop2Name.equalsIgnoreCase(propName)) continue;
                            addValue = false;
                            break;
                        }
                        if (addValue) continue;
                        break;
                    }
                } else {
                    addValue = false;
                }
                if (!addValue) continue;
                filteredArg.addValue(value);
            }
            if (filteredArg.hasValue()) {
                this.getCommandBuilder().addArgument(filteredArg);
            }
        }
        argsCopy = new LinkedList<Argument>(this.getCommandBuilder().getArguments());
        for (Argument arg : argsCopy) {
            if (!arg.getName().equals("reset") && !arg.getName().equals("remove")) continue;
            this.getCommandBuilder().removeArgument(arg);
        }
        if (isNameProvidedInteractively) {
            arg = new StringArgument(providedNamingArgName, null, providedNamingArgName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get(d.getUserFriendlyName()));
            arg.addValue(child.getManagedObjectPath().getName());
            this.getCommandBuilder().addArgument(arg);
        } else {
            for (Argument arg : this.namingArgs) {
                if (!arg.isPresent()) continue;
                this.getCommandBuilder().addArgument(arg);
            }
        }
        return MenuResult.success(0);
    }

    private <T> void setProperty(ManagedObject<?> mo, MyPropertyProvider provider, PropertyDefinition<T> pd) {
        Collection<T> values = provider.getPropertyValues(pd);
        mo.setPropertyValues(pd, values);
    }

    private static Argument createArgument(PropertyEditorModification mod) throws ArgumentException {
        StringArgument arg;
        String propName = mod.getPropertyDefinition().getName();
        switch (mod.getType()) {
            case ADD: {
                arg = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                break;
            }
            case SET: {
                arg = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                break;
            }
            case RESET: {
                arg = new StringArgument(OPTION_DSCFG_LONG_RESET, null, OPTION_DSCFG_LONG_RESET, false, true, true, ToolMessages.INFO_PROPERTY_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get());
                arg.addValue(propName);
                break;
            }
            case REMOVE: {
                arg = new StringArgument(OPTION_DSCFG_LONG_REMOVE, null, OPTION_DSCFG_LONG_REMOVE, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                arg = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modification type: " + (Object)((Object)mod.getType()));
            }
        }
        return arg;
    }

    private String getTypeName(ManagedObjectDefinition<? extends C, ? extends S> d) {
        String name = d.getName();
        for (String key : this.types.keySet()) {
            ManagedObjectDefinition current = (ManagedObjectDefinition)this.types.get(key);
            if (!current.equals(d)) continue;
            name = key;
            break;
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeHelpCallback<C extends ConfigurationClient, S extends Configuration>
    implements HelpCallback {
        private final AbstractManagedObjectDefinition<C, S> d;

        private TypeHelpCallback(AbstractManagedObjectDefinition<C, S> d) {
            this.d = d;
        }

        @Override
        public void display(ConsoleApplication app) {
            app.println(DSConfigMessages.INFO_DSCFG_CREATE_TYPE_HELP_HEADING.get(this.d.getUserFriendlyPluralName()));
            app.println();
            app.println(this.d.getSynopsis());
            if (this.d.getDescription() != null) {
                app.println();
                app.println(this.d.getDescription());
            }
            app.println();
            app.println();
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(DSConfigMessages.INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_TYPE.get());
            builder.appendHeading(DSConfigMessages.INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_DESCR.get());
            boolean isFirst = true;
            for (ManagedObjectDefinition mod : CreateSubCommandHandler.getSubTypes(this.d).values()) {
                if (!app.isAdvancedMode() && (mod.hasOption(ManagedObjectOption.ADVANCED) || CLIProfile.getInstance().isForCustomization(mod))) continue;
                Message ufn = mod.getUserFriendlyName();
                Message synopsis = mod.getSynopsis();
                Message description = mod.getDescription();
                if (CLIProfile.getInstance().isForCustomization(mod)) {
                    ufn = DSConfigMessages.INFO_DSCFG_CUSTOM_TYPE_OPTION.get(ufn);
                    synopsis = DSConfigMessages.INFO_DSCFG_CUSTOM_TYPE_SYNOPSIS.get(ufn);
                    description = null;
                } else if (mod == this.d) {
                    ufn = DSConfigMessages.INFO_DSCFG_GENERIC_TYPE_OPTION.get(ufn);
                    synopsis = DSConfigMessages.INFO_DSCFG_GENERIC_TYPE_SYNOPSIS.get(ufn);
                    description = null;
                }
                if (!isFirst) {
                    builder.startRow();
                    builder.startRow();
                } else {
                    isFirst = false;
                }
                builder.startRow();
                builder.appendCell(ufn);
                builder.appendCell(synopsis);
                if (description == null) continue;
                builder.startRow();
                builder.startRow();
                builder.appendCell();
                builder.appendCell(description);
            }
            TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
            printer.setColumnWidth(1, 0);
            printer.setColumnSeparator(":");
            builder.print(printer);
            app.println();
            app.pressReturnToContinue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyPropertyProvider
    implements PropertyProvider {
        private final Map<PropertyDefinition<?>, Collection<?>> properties = new HashMap();

        public MyPropertyProvider(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> namingPropertyDefinition, List<String> args) throws ArgumentException {
            for (String s : args) {
                PropertyDefinition<?> pd;
                int sep = s.indexOf(58);
                if (sep < 0) {
                    throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(s);
                }
                if (sep == 0) {
                    throw ArgumentExceptionFactory.missingNameInPropertyArgument(s);
                }
                String propertyName = s.substring(0, sep);
                String value = s.substring(sep + 1, s.length());
                if (value.length() == 0) {
                    throw ArgumentExceptionFactory.missingValueInPropertyArgument(s);
                }
                try {
                    pd = d.getPropertyDefinition(propertyName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
                }
                if (pd.equals(namingPropertyDefinition)) {
                    throw ArgumentExceptionFactory.unableToSetNamingProperty(d, pd);
                }
                this.addPropertyValue(d, pd, value);
            }
        }

        public Set<PropertyDefinition<?>> getProperties() {
            return this.properties.keySet();
        }

        @Override
        public <T> Collection<T> getPropertyValues(PropertyDefinition<T> d) throws IllegalArgumentException {
            Collection<?> values = this.properties.get(d);
            if (values == null) {
                return Collections.emptySet();
            }
            return values;
        }

        private <T> void addPropertyValue(ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd, String s) throws ArgumentException {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (IllegalPropertyValueStringException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            Collection<?> values = this.properties.get(pd);
            if (values == null) {
                values = new LinkedList();
            }
            values.add(value);
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                PropertyIsSingleValuedException e = new PropertyIsSingleValuedException(pd);
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            this.properties.put(pd, values);
        }
    }
}

