/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;

public class SetGenerationIdTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    boolean isCompressed = false;
    boolean isEncrypted = false;
    boolean skipSchemaValidation = false;
    String domainString = null;
    ReplicationDomain domain = null;
    TaskState initState;
    Long generationId = null;

    private static final void debugInfo(String s) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(s);
        }
    }

    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_SET_GENERATION_ID_NAME.get();
    }

    public void initializeTask() throws DirectoryException {
        AttributeType typeNewValue;
        if (TaskState.isDone(this.getTaskState())) {
            return;
        }
        Entry taskEntry = this.getTaskEntry();
        List<Attribute> attrList = taskEntry.getAttribute(typeNewValue = DirectoryServer.getAttributeType("ds-task-reset-generation-id-new-value", true));
        if (attrList != null && !attrList.isEmpty()) {
            try {
                this.generationId = new Long(TaskUtils.getSingleValueString(attrList));
            }
            catch (Exception e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_GENERATION_ID.get());
                mb.append(e.getMessage());
                throw new DirectoryException(ResultCode.CLIENT_SIDE_PARAM_ERROR, mb.toMessage());
            }
        }
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-reset-generation-id-domain-base-dn", true);
        attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        DN domainDN = DN.nullDN();
        try {
            domainDN = DN.decode(this.domainString);
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_DN.get());
            mb.append(e.getMessage());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, mb.toMessage());
        }
        this.domain = ReplicationDomain.retrievesReplicationDomain(domainDN);
    }

    protected TaskState runTask() {
        SetGenerationIdTask.debugInfo("setGenerationIdTask is starting on domain%s" + this.domain.getBaseDN());
        try {
            this.domain.resetGenerationId(this.generationId);
        }
        catch (DirectoryException de) {
            this.logError(de.getMessageObject());
            return TaskState.STOPPED_BY_ERROR;
        }
        SetGenerationIdTask.debugInfo("setGenerationIdTask is ending SUCCESSFULLY");
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

